define(['jquery', 'core/modal_factory', 'core/templates', 'core/str', 'block_ned_teacher_tools/userextension'],
    function($, ModalFactory, Templates, str, UserExtension) {
        return {
            init: function(contextid) {
                let plugin_name = 'local_ned_controller';

                let $table = $('#datatable[data-resubmit_max_time]');
                if ($table.length > 0){
                    let $resubmission_info = $(`body.ned-student-progress td.lastcol .resubmission-info`);
                    let $resubmission_buttons = $resubmission_info.children('input[type="submit"]');
                    let $resubmission_indicators = $table.find('.resubmission-time[data-resubmission_time_start]');
                    let resubmission_max_time = +$table.data('resubmit_max_time');

                    $resubmission_buttons.on('click', function() {
                        let elem = $(this);
                        let href = elem.attr('href');
                        if (href){
                            window.open(elem.attr('href'),"_self");
                        }
                    });

                    Resubmission_check_time($resubmission_indicators, resubmission_max_time);
                }

                $('#mark-interface a.resubmission-help').on('click', function(e) {
                    e.preventDefault();
                    let elem = $(this);
                    let data = {};
                    [data.max_time, data.show_pp, data.pp, data.attempts, data.max_attempts] = elem.data('data').split(' ');
                    ModalFactory.create({
                        type: ModalFactory.types.SAVE_CANCEL,
                        title: str.get_string('resubmission_modal:title', plugin_name, elem.data('course')),
                        body: Templates.render(plugin_name + '/resubmission_modal_body', data),
                    })
                        .then(function(modal) {
                            modal.getModal().addClass(plugin_name + '_resubmission_modal');
                            modal.setSaveButtonText(str.get_string('close', plugin_name));
                            modal.show();
                        });
                });


                function Resubmission_check_time($resubmission_indicators, resubmission_max_time){
                    clearTimeout(Resubmission_check_time.timerid);
                    $resubmission_indicators.each(function(index, elem){
                        if (elem && !elem.parentElement) return;
                        let $_elem = $(elem);
                        if (+resubmission_max_time === 0){
                            $_elem.text('∞');
                            return;
                        }

                        let now = Math.round(new Date().getTime()/1000);
                        let resubmission_time_start = +$_elem.data('resubmission_time_start');
                        let time_after_start = now - resubmission_time_start;
                        let time_del = resubmission_max_time - time_after_start;

                        if (!resubmission_time_start || time_del < 0){
                            let $parent = $(elem.parentElement);
                            $parent.removeClass('rm-not-allowed').removeClass('rm-unlock').addClass('rm-lock');
                            elem.parentElement.firstChild.remove();
                            elem.remove();
                        } else {
                            $_elem.text(time2str(time_del));
                        }

                    });
                    if (+resubmission_max_time !== 0){
                        Resubmission_check_time.timerid = setTimeout(function(){
                            Resubmission_check_time($resubmission_indicators, resubmission_max_time);
                        }, 1000);
                    }
                }

                function time2str(time_del){
                    let sign = '';
                    if (time_del < 0){
                        time_del = Math.abs(time_del);
                        sign = '-';
                    }
                    let h = Math.floor(time_del/3600);
                    time_del -= h*3600;
                    let m = Math.floor(time_del/60);
                    let s = time_del - m*60;
                    let f = {'minimumIntegerDigits': 2};
                    return sign + h.toLocaleString(0, f) + ':' + m.toLocaleString(0, f) + ':' + s.toLocaleString(0, f);
                }

                UserExtension.add('table.student-progress', contextid);
            }
        };
    });
