<?php
/**
 * @package    local_ned_controller
 * @category   NED
 * @copyright  2023 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller;

defined('MOODLE_INTERNAL') || die();

/**
 * Trait base_child_class_magic
 * @package local_ned_controller
 * @see base_child_class for the base documentation
 *
 * Trait to make child class is more linked to the parent class.
 * It's {@see base_child_class} trait with overridden magic methods,
 *  so you can natively access parent private properties and call parent private methods as with protected properties/methods
 * - but not for the static properties/methods
 *
 * Note, that it makes all parent properties/methods also accessible outside the class,
 *  if it's not fine to you, use {@see base_child_class} and override magic methods in suitable for your way.
 * Also, it overrides all these magic methods from the parent class
 *
 * Remember, that you need to redeclare parent private properties/methods in the PHPDoc (as public) to see help from IDE
 */
trait base_child_class_magic{
    use base_child_class;

    /**
     * @param string $name
     *
     * @return mixed|null
     */
    public function __get($name){
        return $this->_bcc_get($name);
    }

    /**
     * @param string $name
     * @param mixed  $value
     *
     * @return mixed|null
     */
    public function __set($name, $value){
        return $this->_bcc_set($name, $value);
    }

    /**
     * @param string $name
     * @param array  $arguments
     *
     * @return mixed|null
     */
    public function __call($name, $arguments){
        return $this->_bcc_call($name, ...$arguments);
    }

    /**
     * @param string $name
     *
     * @return bool
     */
    public function __isset($name){
        return $this->_bcc_isset($name);
    }

    /**
     * @param string $name
     *
     * @return void
     */
    public function __unset($name){
        $this->_bcc_unset($name);
    }
}
