<?php
/**
 * @package    local_ned_controller
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller;

defined('MOODLE_INTERNAL') || die();

/**
 * Trait base_empty_class
 *
 * @package local_ned_controller
 */
trait base_empty_class{

    /**
     * Check all $this properties and set value of $object (if it exists) or set $default if $set_default true
     *
     * @param        $object
     * @param false  $set_default
     * @param null   $default
     * @param string $r_prefix
     */
    protected function import($object, $set_default=false, $default=null, $r_prefix=''){
        $object = is_object($object) ? $object : new \stdClass();
        foreach ($this as $prop => $value){
            $r_prop = $r_prefix . $prop;
            if (property_exists($object, $r_prop)){
                $this->$prop = $object->$r_prop;
            } elseif($set_default){
                $this->$prop = $default;
            }
        }
    }

    /**
     * Check all $object properties and set them to $this
     *
     * @param        $object
     * @param string $w_prefix
     * @param bool   $check_existing
     */
    protected function copy($object, $w_prefix='', $check_existing=true){
        $object = is_object($object) ? $object : new \stdClass();
        foreach ($object as $prop => $value){
            $w_prop = $w_prefix . $prop;
            if (!$check_existing || property_exists($this, $w_prop)){
                $this->$w_prop = $value;
            }
        }
    }

    /**
     * Check all $object properties and if $this has it - set it to $object
     *
     * @param        $object
     * @param string $w_prefix
     *
     * @return object $object
     */
    protected function copy2object($object, $w_prefix=''){
        $object = is_object($object) ? $object : new \stdClass();
        foreach ($object as $prop => $value){
            $w_prop = $w_prefix . $prop;
            if (property_exists($this, $w_prop)){
                $object->$prop = $this->$w_prop;
            }
        }

        return $object;
    }

    /**
     * @param string $prefix
     * @param bool   $skip_protected
     * @param bool   $protected2public - if $skip_protected is true - ignored
     *
     * @return \stdClass
     */
    public function export($prefix='', $skip_protected=true, $protected2public=false){
        $object = new \stdClass();
        foreach ($this as $prop => $value){
            if ($prop[0] == '_'){
                if ($skip_protected){
                    continue;
                } elseif ($protected2public){
                    $prop = substr($prop, 1);
                }
            }

            $pref_prop = $prefix . $prop;
            $object->$pref_prop = $value;
        }
        return $object;
    }

    /**
     * @param $name
     *
     * @return null|mixed
     */
    public function __get($name){
        $pr_name = '_' . $name;
        $res = null;

        if (property_exists($this, $name)){
            $res = ($this::${$name} ?? $this->$name) ?? null;
        } elseif (property_exists($this, $pr_name)){
            $res = ($this::${$pr_name} ?? $this->$pr_name) ?? null;
        }

        if (is_object($res)){
            $res = clone($res);
        }

        return $res;
    }

    /**
     * @param $name
     *
     * @return bool
     */
    public function __isset($name){
        $pr_name = '_' . $name;

        if (property_exists($this, $name)){
            return true;
        } elseif (property_exists($this, $pr_name)){
           return true;
        }

        return false;
    }

    /**
     * @param $name
     * @param $value
     *
     * @return null
     */
    public function __set($name, $value){
        if (isset($this->$name)){
            return null;
        } else {
            $this->$name = $value;
            return $value;
        }
    }
}
