<?php
/**
 * @package    local_ned_controller
 * @category   NED
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller;

defined('MOODLE_INTERNAL') || die();

/**
 * Trait base_get_set_for_class
 *
 * @package local_ned_controller
 */
trait base_get_set_for_class{
    /**
     * @param $name
     *
     * @return null|mixed
     */
    public function __get($name){
        $pr_name = '_' . $name;
        return $this->$pr_name ?? null;
    }

    /**
     * @param $name
     *
     * @return bool
     */
    public function __isset($name){
        $pr_name = '_' . $name;
        return isset($this->$pr_name);
    }

    /**
     * @param $name
     * @param $value
     *
     * @return null
     */
    public function __set($name, $value){
        $pr_name = '_' . $name;
        if (property_exists(__CLASS__, $pr_name) || property_exists(__CLASS__, $name)){
            return null;
        } else {
            $this->$name = $value;
            return $value;
        }
    }
}
