<?php

/**
 * The mod_assign submission force add attempt event.
 *
 * @package    local_ned_controller
 * @subpackage event
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\event;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

/**
 * The mod_assign submission force add attempt event class.
 *
 * @package local_ned_controller
 */
class submission_force_add_attempt extends submission_changes_base {

    /**
     * Returns localised general event name.
     *
     * @return string
     */
    public static function get_name() {
        return NED::str('eventsubmissionforceaddattempt');
    }

    /**
     * Returns non-localised description of what happened.
     *
     * @return string
     */
    public function get_description() {
        $author = $this->other['author'];
        $attempt = $this->other['submissionattempt'] ?? -1;
        $attempt = ($attempt+1) ?: '?';
        return "The user '$this->userid' add new attempt (attempt '$attempt', submission '$this->objectid') authored by user `$author` ".
            "for the user '$this->relateduserid' for the assignment with course module id '$this->contextinstanceid'.";
    }

    /**
     * Create instance of event.
     *
     * @param \assign|\local_ned_controller\mod_assign\assign $assign
     * @param \stdClass                                       $submission
     * @param int|string                                      $author
     *
     * @return submission_remove_grades
     */
    public static function create_from_submission($assign, $submission, $author=false) {
        $params = static::get_event_params($assign, $submission, $author);
        return static::create_event_by_params($assign, $submission, $params);
    }

    /**
     * @param \assign|\local_ned_controller\mod_assign\assign $assign
     * @param \stdClass                                       $submission
     * @param int|string                                      $author
     *
     * @return array
     */
    public static function get_event_params($assign, $submission, $author=null){
        global $USER;
        $params = parent::get_event_params($assign, $submission);
        $params['other']['author'] = $author ?: $USER->id;

        return $params;
    }

    /**
     * Custom validation.
     *
     * @return void
     * @throws \coding_exception
     */
    protected function validate_data() {
        parent::validate_data();

        if (!isset($this->other['author'])) {
            throw new \coding_exception('The \'author\' value must be set in other.');
        }
    }
}
