<?php
/**
 *  The mod_assign submission graded event.
 *
 * @package    local_ned_controller
 * @subpackage NED
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\event;

defined('MOODLE_INTERNAL') || die();

/**
 * Override the mod_assign submission graded event class.
 *
 * @package    local_ned_controller
 */
class submission_graded extends \mod_assign\event\submission_graded {

    /**
     * Create instance of event.
     *
     * @param \assign | \local_ned_controller\mod_assign\assign |  $assign
     * @param \stdClass                                            $grade
     *
     * @return \mod_assign\event\submission_graded|\local_ned_controller\event\submission_graded
     */
    public static function create_from_grade($assign, \stdClass $grade) {
        $event = parent::create_from_grade($assign, $grade);
        $event->data['other']['maxattempt'] = $grade->maxattempt ?? $grade->attemptnumber;
        $event->data['other']['attempt'] = $grade->attemptnumber;

        return $event;
    }

    /**
     * Returns description of what happened.
     *
     * @return string
     */
    public function get_description() {
        $maxattempt = $this->data['other']['maxattempt'] ?? 0;
        $attempt = $this->data['other']['attempt'] ?? 0;
        $maxattempt++;
        $attempt++;
        return "The user with id '$this->userid' has graded the submission (assign grade '$this->objectid', attempt $attempt/$maxattempt) 
            for the user with id '$this->relateduserid' for the assignment with course module id '$this->contextinstanceid'.";
    }
}
