<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package    local_ned_controller
 * @subpackage NED
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller;

defined('MOODLE_INTERNAL') || die();

/**
 * WARNING: This library probably does not work correctly!
 * @deprecated
 *
 * Simple class for using the github oauth api:
 *
 * @package githubapi
 */
class githubapi {
    /**
     *
     * @var array $errors holding errors
     */
    public $errors = array ();

    /**
     * @var string return code
     */
    public $returnCode = null;

    public $redirectURL = null;

    /**
     * We need a github OAuth login url from configuration
     *
     * @param array $config e.g.
     *
     * <code>
     * $config = array (
     *     'redirect_uri' => 'http://localhost:8080/callback.php',
     *     'client_id' => 'app id',
     *     'state' =>  md5(uniqid()),
     *     'scope' => 'user'
     * );
     * </code>
     *
     * If you don't set scope you can only get users basic profile info,
     * but you can still use it as e.g. a login method.
     *
     * @return string $url a github url where you can obtain users accept of
     *                     using his account according to scope
     */
    public function getAccessUrl($config) {
        $_SESSION['state'] = $config['state'];
        $url               = 'https://github.com/login/oauth/authorize';
        $query             = http_build_query( $config );
        $url               .= '?' . $query;

        return $url;
    }

    /**
     * Sets the access token in a session variable, which
     * then can be used when calling the api
     *
     * @param array $post e.g.
     *
     * <code>
     * $post = array (
     *     'redirect_uri' => 'http://localhost:8080/callback.php',
     *     'client_id' => 'app_id',
     *     'client_secret' => 'app_secret',
     * );
     * </code>
     *
     * @return boolean $res true on success and false on failure
     *                 any errors will be stored in githubapi::$errors
     */
    public function setAccessToken( $post ) {
        if ( isset( $_GET['error'] ) ) {
            $this->errors[] = $_GET['error'];

            return false;
        }

        if ( isset( $_GET['code'] ) ) {
            $c            = new mycurl( 'https://github.com/login/oauth/access_token' );
            $post['code'] = $_GET['code'];

            $c->setPost( $post );
            $c->createCurl();
            $resp = $c->getWebPage();

            parse_str( $resp, $ary );

            if ( isset( $ary['access_token'] ) && isset( $ary['token_type'] ) && $ary['token_type'] == 'bearer' ) {
                update_option( "github_oauth_api_access_token", $ary['access_token'] );

                return true;
            } else {
                $this->errors[] = "No access token returned";

                return false;
            }
        }

        return false;
    }

    /**
     * Make an API call. For all
     *
     * @see http://developer.github.com/v3/
     *
     * @param string  $command e.g "/users"
     * @param string  $request e.g "POST" or PATCH, DELETE - if empty it is a GET
     * @param array   $post    vaiables $_POST variables to send
     * @param boolean $json    should we return output as json. Default is false
     *
     * @return boolean|array false if failure. Else: $ary response from github server
     */
    public function apiCall( $command, $request = null, $params = array(), $post = null, $json = false ) {
        $token = 'b99050d6b5abce53533ea30d27b8f266b998be87';
        if (!isset($token) || empty($token)) {
            $this->errors[] = 'No valid token';

            return false;

        }
        $end_point = 'https://api.github.com';
        $command   = $end_point . "$command";
        $command   .= "?access_token=$token";

        if ( !empty( $params ) ) {
            $params  = http_build_query( $params );
            $command .= "&$params";
        }

        $c = new mycurl( $command );
        if ( isset( $request ) ) {
            $c->setRequest( $request );
        }
        if ( isset( $post ) ) {
            $post_json = json_encode( $post );
            $c->setPost( [$post_json] );
        }


        $c->createCurl();
        $resp              = $c->getWebPage();
        $this->returnCode  = $c->getHttpStatus();
        $this->redirectURL = $c->getRedirectURL();
        if ( $json ) {
            return $resp;
        } else {
            $ary = json_decode( $resp, true );

            return $ary;
        }
    }

    /**
     * List your repositories
     * List repositories that the authenticated user has explicit permission (:read, :write, or :admin) to access.
     *
     * @param array $parameter
     *
     * @return array|bool
     */
    function get_users_repo( $parameter = array() ) {
        //check https://developer.github.com/v3/repos/
        /*$parameter = array(
            'visibility' => 'all',
        );*/

        $result = $this->apiCall( "/user/repos", 'GET', $parameter );
        if ( $result ) {
            return $result;
        } else {
            return $result->errors;
        }
    }

    /**
     * List user repositories
     * List public repositories for the specified user.
     * GET /users/:username/repos
     *
     * @param       $username
     * @param array $parameter
     *
     * @return array|bool
     */
    function get_repoBy_usernames( $username, $parameter = array() ) {
        //check https://developer.github.com/v3/repos/
        /*$parameter = array(
            'type' => 'all',
        );*/

        $result = $this->apiCall( "/users/" . $username . "/repos", 'GET', $parameter );
        if ( $result ) {
            return $result;
        } else {
            return $result->errors;
        }
    }

    /**
     * List commits on a repository
     * GET /repos/:owner/:repo/commits
     *
     * @param       $username
     * @param array $parameter
     *
     * @return array
     */
    function list_commits_by_repository( $username, $parameter = array() ) {
        $result = $this->apiCall( "/repos/" . $username . "/:repo/commits", 'GET', $parameter );
        if ( $result ) {
            return $result;
        } else {
            return $result->errors;
        }
    }

    /**
     * List issues by repository and username
     *
     * @param       $username
     * @param       $repository
     * @param array $parameter
     *
     * @return array|bool
     */
    function list_issues_by_repo( $username, $repository, $parameter = array() ) {
        $result = $this->apiCall( "/repos/" . $username . "/" . $repository . "/issues", 'GET', $parameter );
        if ( $result ) {
            return $result;
        } else {
            return $result->errors;
        }
    }

    /**
     * Get repository contents
     *
     * @param       $username
     * @param       $repository
     * @param       $path
     * @param array $parameter
     *
     * @return array|bool
     */
    function get_contents_of_repo( $username, $repository, $path, $parameter = array() ) {
        $result = $this->apiCall( "/repos/" . $username . "/" . $repository . "/contents/" . $path, 'GET', $parameter );
        if ( $result ) {
            return $result;
        } else {
            return $result->errors;
        }
    }

    /**
     *  Get File Download
     *
     * @param $username
     * @param $repository
     *
     * @return string
     */
    function download_repository( $username, $repository ) {
        $token  = get_option( 'github_oauth_api_access_token' );
        $result = "https://github.com/" . $username . "/" . $repository . "/archive/master.zip?login=" . $username . "&token=84f3e5e33979d202f40ba64306daec3a683b76cb";
        if ( $result ) {
            return $result;
        }
    }

    function archive_link( $username, $repository, $archive_format = "zipball", $ref = "master" ) {
        $this->apiCall( "/repos/" . $username . "/" . $repository . "/" . $archive_format . "/" . $ref, 'GET', false, false, true );
        if ($this->redirectURL ) {
            return $this->redirectURL;
        }
    }
}