<?php
/**
 * @package    local_ned_controller
 * @subpackage marking_manager
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\marking_manager;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

/**
 * Class MM_base
 * // it can be trait, but trait can't have constants...
 *
 * @package local_ned_controller\marking_manager
 */
abstract class MM_base {
    use \local_ned_controller\base_empty_class;

    /** @see marking_manager_assign */
    const MOD_ASSIGN = NED::MOD_ASSIGN;
    /** @see marking_manager_quiz */
    const MOD_QUIZ = NED::MOD_QUIZ;
    /** @see marking_manager_forum */
    const MOD_FORUM = NED::MOD_FORUM;
    /** @see marking_manager_journal */
    const MOD_JOURNAL = NED::JOURNAL;
    /** @see marking_manager_feedback */
    const MOD_FEEDBACK = NED::FEEDBACK;
    /** @see marking_manager_h5pactivity */
    const MOD_H5PACTIVITY = NED::H5PACTIVITY;

    const MOD_ALL = 'allactivitytypes';
    const MOD_TYPES = [self::MOD_ASSIGN, self::MOD_QUIZ, self::MOD_FORUM, self::MOD_JOURNAL, self::MOD_FEEDBACK, self::MOD_H5PACTIVITY];
    const SELECT_MOD = [self::MOD_ALL, self::MOD_ASSIGN, self::MOD_FORUM, self::MOD_JOURNAL, self::MOD_FEEDBACK, self::MOD_QUIZ, self::MOD_H5PACTIVITY];

    const ST_MARKED = NED::STATUS_MARKED;
    const ST_UNMARKED = NED::STATUS_UNMARKED; // haven't grade, but need it
    const ST_SUBMITTED = NED::STATUS_SUBMITTED;
    const ST_UNSUBMITTED = NED::STATUS_UNSUBMITTED;
    const ST_DRAFT = NED::STATUS_DRAFT;
    // secondary
    const ST_REOPENED = 'reopened';
    const ST_MISSED_DEADLINE = 'missed_deadline'; // ST_SUBMITTED_MISSED_DEADLINE OR ST_UNSUBMITTED_MISSED_DEADLINE
    const ST_UNMARKED_MISSED_DEADLINE = 'unmarked_missed_deadline'; // DEADLINE_PAST + ST_UNSUBMITTED + ST_GRADE_NOT
    const ST_UNMARKED_MISSED_DEADLINE_GRACE = 'unmarked_missed_deadline_grace'; // DEADLINE_PAST_GRACE + ST_UNSUBMITTED + ST_GRADE_NOT
    const ST_UNMARKED_DUE_12h = 'unmarked_due_12h'; // ST_UNSUBMITTED + ST_GRADE_NOT + deadline < 12h from now
    const ST_UNMARKED_DUE_24h = 'unmarked_due_24h'; // ST_UNSUBMITTED + ST_GRADE_NOT + deadline < 24h from now
    const ST_UNMARKED_DUE_IMPORTANT = 'unmarked_due_important'; // ST_UNMARKED_MISSED_DEADLINE + ST_UNMARKED_DUE_24h + ST_UNMARKED_DUE_12h
    const ST_SUBMITTED_MISSED_DEADLINE = 'submitted_missed_deadline'; // DEADLINE_PAST + ($sql_deadline < $sql_submit)
    const ST_UNSUBMITTED_MISSED_DEADLINE = 'unsubmitted_missed_deadline'; // DEADLINE_PAST + ST_UNSUBMITTED
    const ST_UNSUBMITTED_MISSED_DEADLINE_GRACE = 'unsubmitted_missed_deadline_grace'; // DEADLINE_PAST_GRACE + ST_UNSUBMITTED
    const ST_WAITING_ZERO = 'waitingzero';
    const ST_ZERO_GRADE = 'zerograde';
    const ST_GRADE_LESS_50 = 'grade_less_50';
    const ST_GRADE_NOT = 'grade_not';
    const ST_ALL = 'allstatustypes'; // it's all MM_SELECT_STATUS
    const ST_GM_POSSIBLE = 'gm_possible';

    const SELECT_STATUS = [self::ST_UNMARKED, self::ST_MARKED, self::ST_UNSUBMITTED, self::ST_DRAFT];
    // It's all statuses which you can choose on the main MM page: here should be MM_WFG_TYPES + MM_FILTER_TYPES
    // MM select all these statuses, if you choose self::ST_ALL
    // Also this statuses show in usual render table is "status" column
    const MM_SELECT_STATUS = [self::ST_ALL, self::ST_UNMARKED, self::ST_MARKED, self::ST_UNSUBMITTED, self::ST_SUBMITTED, self::ST_DRAFT,
        self::ST_ZERO_GRADE, self::ST_GRADE_LESS_50, self::ST_UNMARKED_MISSED_DEADLINE,
        self::ST_SUBMITTED_MISSED_DEADLINE, self::ST_UNSUBMITTED_MISSED_DEADLINE,
        self::ST_UNMARKED_DUE_12h, self::ST_UNMARKED_DUE_24h,
    ];
    // main filters for the page
    const MM_WFG_TYPES = [self::ST_UNMARKED, self::ST_UNMARKED_MISSED_DEADLINE, self::ST_DRAFT];
    // + filters for the page
    const MM_FILTER_TYPES = [
        self::ST_MARKED, self::ST_SUBMITTED, self::ST_UNSUBMITTED,
        self::ST_GRADE_LESS_50, self::ST_SUBMITTED_MISSED_DEADLINE, self::ST_UNSUBMITTED_MISSED_DEADLINE,
        self::ST_UNMARKED_DUE_12h, self::ST_UNMARKED_DUE_24h,
        self::ST_ZERO_GRADE, self::ST_ALL
    ];
    // Here should be real all MM statuses (Not COUNT_*)
    const MM_ALL_STATUSES = [
        self::ST_MARKED, self::ST_UNMARKED, self::ST_SUBMITTED, self::ST_UNSUBMITTED, self::ST_DRAFT, self::ST_REOPENED,
        self::ST_MISSED_DEADLINE,  self::ST_WAITING_ZERO, self::ST_ZERO_GRADE, self::ST_GRADE_NOT, self::ST_GRADE_LESS_50,
        self::ST_UNMARKED_MISSED_DEADLINE, self::ST_SUBMITTED_MISSED_DEADLINE, self::ST_UNSUBMITTED_MISSED_DEADLINE,
        self::ST_UNMARKED_DUE_12h, self::ST_UNMARKED_DUE_24h, self::ST_UNMARKED_DUE_IMPORTANT, self::ST_GM_POSSIBLE,
        self::ST_ALL,
    ];
    // Statuses with unique table render method; Also only these statuses don't use deadline by default
    const NON_PERSONAL_STATUSES = [self::ST_UNMARKED, self::ST_MARKED];
    // Should have deadline for such statuses
    const SHOULD_HAVE_DEADLINE = [
        self::ST_WAITING_ZERO,
        self::ST_MISSED_DEADLINE,
        self::ST_UNMARKED_MISSED_DEADLINE,
        self::ST_UNMARKED_DUE_12h,
        self::ST_UNMARKED_DUE_24h,
        self::ST_UNMARKED_DUE_IMPORTANT,
        self::ST_SUBMITTED_MISSED_DEADLINE,
        self::ST_UNSUBMITTED_MISSED_DEADLINE,
        self::DEADLINE_PAST,
        self::DEADLINE_NOTSET,
        self::DEADLINE_UPCOMING,
    ];

    const KICAGRADE = 'kicagrade';
    const USE_KICA = 'use_kica';
    const USE_DEADLINE = 'use_deadline';
    const USE_GROUPS = 'use_groups';
    const USE_GM = 'use_gm';
    const USE_GM_ATTEMPT = 'use_gm_attempt';

    // By default, MM checks student role from users on course OR cm level, but you change this behavior by next filters
    const DONT_CHECK_STUDENT_ROLE = 'dont_check_student_role';
    const USE_COURSE_STUDENTS_ONLY = 'use_course_students_only';
    const USE_CM_STUDENTS_ONLY = 'use_cm_students_only';
    const USE_DEF_STUDENTS_ONLY = 'use_def_students_only'; // use users only with "Student" as default role in user profile

    const HAVE_DEADLINE = 'have_deadline';
    const DEADLINE_NOTSET = 'deadline_notset'; // no deadline at all
    const DEADLINE_PAST = 'deadline_past'; // was
    const DEADLINE_PAST_GRACE = 'deadline_past_grace'; // was, with the deadline grace period
    const DEADLINE_UPCOMING = 'deadline_upcoming'; // will
    const DEADLINE_UPTO = 'deadline_upto'; // upto some date - all deadline <= X
    const DEADLINE_AFTER = 'deadline_after'; // after some date - all deadline >= X
    const VALUE_DEADLINE = [self::DEADLINE_NOTSET, self::DEADLINE_PAST, self::DEADLINE_UPCOMING];

    const SUM = 'sum';
    const SORT = 'sort';
    const CTA_ORDER = 'cta_order';

    const BY_ACTIVITY = 'by_activity';
    const BY_USER = 'by_user';
    const BY_ACTIVITY_USER = 'by_activity_user';
    const ACTIVITY_ID = 'activity_id';
    const COURSEMODULE_IDS = 'coursemodule_ids';    // it can be one cm id, or list of them
    const CMIDS = self::COURSEMODULE_IDS; // alias
    const NOT_ZERO = 'not_zero';
    const ONLY_KICA = 'only_kica';
    const ONLY_EXCLUDED = 'only_excluded';
    const NOT_EXCLUDED = 'not_excluded';
    const USE_TAGS = 'use_tags';
    const GET_TAGS = 'get_tags';
    const CHECK_TAG = 'check_tag'; // tag id which should be in activity, or static::TAGS_NONE, or static::TAGS_ALL
    const TAG_NAME_LIST_HAVE_ALL = 'tag_name_list_have_all'; // array of tag names, all of them should be in activity
    const TAG_NAME_LIST_HAVE_ANY = 'tag_name_list_have_any'; // array of tag names, any of them should be in activity
    const TAG_NAME_LIST_HAVE_NONE = 'tag_name_list_have_none'; // array of tag names, all of them shouldn't be in activity
    const DEADLINE = 'deadline';

    const GET_ST = 'get_st'; // if you wish get some status(es), but not filter by it
    /** @see \local_ned_controller\marking_manager\mm_data_by_user::$grade_feedback */
    const GET_GRADE_COMMENT = 'get_grade_comment';
    const GET_COUNT = 'get_count'; // get count of all possible records first

    const LIMIT_NUM = 'limitnum';
    const LIMIT_FROM = 'limitfrom';

    /**
     * Filter to check grades, values should be numeric to work
     * If value will be int, compare will be with ROUND() values
     */
    const F_GRADE_EQ = 'f_grade_eq';
    const F_GRADE_GTE = 'f_grade_gte';
    const F_GRADE_LTE = 'f_grade_lte';

    const GET_PROXY_ENABLED = 'get_proxy_enabled'; // get info, if activity has any proxy
    const HIDE_GRADES_BEFORE_MIDN = 'hide_grades_before_midn'; // hide today grades before midnight time

    const ONLY_GM = 'only_gm';
    const ONLY_NOT_GM = 'only_not_gm';
    const GM_SHOULDPASS = 'gm_shouldpass';
    const GM_NGC_FILTER = 'gm_ngc_filter'; // filter "on" for GM by NGC
    const GM_STARTDATE = 'gm_startdate'; // UNIX time value

    const ONLY_NGC = 'only_ngc';
    const ONLY_NOT_NGC = 'only_not_ngc';
    const NGC_MISSED_DEADLINE = 'ngc_missed_deadline';
    const NGC_LATE_SUBMISSIONS = 'ngc_late_submissions';
    const NGC_FIXED_SUBMISSIONS = 'ngc_fixed_submissions';

    const GROUP_REGEXP = 'group_regexp'; // string, to check group name by REGEXP
    const GROUP_NOT_REGEXP = 'group_not_regexp'; // string, to check group name by NOT REGEXP
    const GROUP_REGEXP_BINARY = 'group_regexp_binary'; // if true, use BINARY REGEXP in the group name check

    const QUIZ_DETAILED_VIEW = 'quiz_detailed_view';
    const DRAFT_DETAILED_VIEW = 'draft_detailed_view';

    const COUNT_WAITING_ZERO = 'count_' . self::ST_WAITING_ZERO;
    const COUNT_DRAFT = 'count_' . self::ST_DRAFT;
    const COUNT_MISSED_DEADLINE = 'count_' . self::ST_MISSED_DEADLINE;
    const COUNT_UNMARKED_MISSED_DEADLINE = 'count_' . self::ST_UNMARKED_MISSED_DEADLINE;
    const COUNT_STATUS = [
        self::COUNT_WAITING_ZERO => self::ST_WAITING_ZERO,
        self::COUNT_DRAFT => self::ST_DRAFT,
        self::COUNT_MISSED_DEADLINE => self::ST_MISSED_DEADLINE,
        self::COUNT_UNMARKED_MISSED_DEADLINE => self::ST_UNMARKED_MISSED_DEADLINE,
    ];

    const TAGS_ALL = 'tags_all';
    const TAGS_NONE = 'tags_none';

    const VIEW_LESS = 'viewless';
    const VIEW_MORE = 'viewmore';
    const VIEW_OPTIONS = [self::VIEW_LESS, self::VIEW_MORE];

    const ALL = 'all';
    const NONE = 'none';

    protected $_records_count = 0;

    /**
     * @param $name
     * @param $value
     *
     * @return null|mixed
     */
    public function __set($name, $value)
    {
        $private_name = '_' . $name;
        if (property_exists($this, $private_name) || ($name[0] == '_' && property_exists($this, $name))){
            return null;
        }
        $this->$name = $value;
        return $value;
    }

    /**
     * @return \moodle_database
     */
    protected static function _db(){
        global $DB;
        return $DB;
    }

    /**
     * Call $fun in the loop for $list as arg
     *  use $not_empty if wish to skip empty results
     *
     * @param array  $list       - list of arguments
     * @param string $fun        - name of the function for the current class
     * @param bool   $not_empty  - if true, don't save empty result
     * @param array  $other_args - const arguments, adding after $list args
     *
     * @return array|null
     */
    protected function _call_fun_list($list, $fun, $not_empty=false, $other_args=[]){
        if (is_array($list)){
            $ans = [];
            foreach ($list as $key => $item){
                $val = $this->$fun($item, ...$other_args);
                if ($not_empty && empty($val)){
                    continue;
                }
                $ans[$key] = $val;
            }
            return $ans;
        } else {
            return null;
        }
    }

    /**
     * Return records count if it was saved
     * Use after {@see static::get_data()}
     *
     * @return int
     */
    public function get_records_count(){
        return $this->_records_count;
    }
}
