<?php
/**
 * @package    local_ned_controller
 * @subpackage marking_manager
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\marking_manager;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();
/** @var \stdClass $CFG */
include_once($CFG->dirroot . '/grade/grading/form/lib.php');
include_once($CFG->dirroot . '/mod/assign/locallib.php');

/**
 * Class marking_manager_assign
 *
 * @package local_ned_controller\marking_manager
 */
class marking_manager_assign extends marking_manager_mod
{
    const HAVE_DEADLINES = true;
    const SQL_USER_TIMEMODIFIED = 'a_s.timemodified';
    const SQL_SUBMIT_TIME = "IF(a_s.status = 'submitted', ".self::SQL_USER_TIMEMODIFIED.", 0)";
    const SQL_DEADLINE = 'COALESCE(ao_user.duedate, ao_group.duedate, a.duedate, 0)';
    const SQL_FINAL_DEADLINE = 'COALESCE(ao_user.cutoffdate, ao_group.cutoffdate, a.cutoffdate, 0)';
    const SQL_ATTEMPT = 'a_s.attemptnumber';
    const SQL_REQUIRE_ONLY_SUBMIT =
        "(a.completionsubmit = 1 AND cm.completion = '".COMPLETION_TRACKING_AUTOMATIC."' AND cm.completiongradeitemnumber is NULL)";

    const SQL_GRADE_FEEDBACK = "IF(a_c.commenttext IS NOT NULL AND a_c.commenttext <> '', a_c.commenttext, gg.feedback)";
    const SQL_GRADE_FEEDBACK_FORMAT = "IF(a_c.commenttext IS NOT NULL AND a_c.commenttext <> '', a_c.commentformat, gg.feedbackformat)";

    const URL_MANUAL_GRADING = '/mod/assign/view.php';

    /**
     * Return type of mod (static::MOD_*), and it's name of main DB-table
     * @return string
     */
    public function get_mod_type(){
        return static::MOD_ASSIGN;
    }

    /**
     * Return condition by there name
     * @param string|array $name
     *
     * @return array|string
     */
    public function sql_get_condition_raw($name){
        if (!is_null($ans = parent::sql_get_condition_raw($name))){
            return $ans;
        }
        $need_upd_status = \gradingform_instance::INSTANCE_STATUS_NEEDUPDATE;
        $sql_not_overridden = $this::SQL_NOT_OVERRIDDEN;
        $sql_graded_by_overridden = $this::SQL_GRADED_BY_OVERRIDDEN;
        $sql_ungraded_by_overridden = $this::SQL_UNGRADED_BY_OVERRIDDEN;

        $st_submitted = ASSIGN_SUBMISSION_STATUS_SUBMITTED;
        $st_draft = ASSIGN_SUBMISSION_STATUS_DRAFT;
        $st_reopened = ASSIGN_SUBMISSION_STATUS_REOPENED;
        switch($name){
            case static::ST_UNSUBMITTED:
                return "a_s.timemodified IS NULL OR a_s.status <> '$st_submitted'";
            case static::ST_SUBMITTED:
                return "a_s.timemodified IS NOT NULL AND a_s.status = '$st_submitted'";
            case static::ST_UNMARKED:
                return "
                    (a_s.timemodified IS NOT NULL AND a_s.status IN ('$st_submitted', '$st_draft') AND $sql_not_overridden AND
                        (
                            (a.grade = 0 AND COALESCE(a_g.grade, -1) = -1 AND COALESCE(a_c.commenttext, '') = '') OR
                            (a.grade <> 0 AND (COALESCE(a_g.grade, -1) = -1 OR COALESCE(a_g.timemodified, 0) < a_s.timemodified))
                        )
                    )  OR (g_inst.status IS NOT NULL AND g_inst.status = $need_upd_status)
                       OR $sql_ungraded_by_overridden".$this->_add_filter_unmarked_cond();
            case static::ST_MARKED:
                return "
                    (
                        (a.grade <> 0 AND COALESCE(a_g.grade, -1) <> -1 AND 
                            a_g.timemodified IS NOT NULL AND a_g.timemodified >= COALESCE(a_s.timemodified, 0)) OR
                        (a.grade = 0 AND COALESCE(a_c.commenttext, '') <> '') OR
                        $sql_graded_by_overridden
                    ) AND 
                    (g_inst.status IS NULL OR g_inst.status <> $need_upd_status)".$this->_add_filter_marked_cond();
            case static::ST_DRAFT:
                return "a_s.status = '$st_draft'";
            case static::ST_REOPENED:
                return "a_s.status = '$st_reopened'";
            default:
                debugging("MM: Unknown condition '$name'");
                return NED::SQL_NONE_COND;
        }
    }

    /**
     * Return base FROM and JOIN statements
     *
     * @return array
     */
    public function sql_get_base_from_basis(){
        $from = [];
        $ctx_level = CONTEXT_MODULE;
        $active_status = \gradingform_instance::INSTANCE_STATUS_ACTIVE;
        $need_upd_status = \gradingform_instance::INSTANCE_STATUS_NEEDUPDATE;
        $from[] = "
        LEFT JOIN {assign_submission} a_s
          ON u.id = a_s.userid
          AND a_s.assignment = a.id
          AND a_s.latest = 1
        LEFT JOIN {assign_grades} a_g
          ON a_s.assignment = a_g.assignment 
          AND a_s.userid = a_g.userid 
          AND (a_s.attemptnumber = a_g.attemptnumber OR a_s.attemptnumber IS NULL)
        LEFT JOIN {assignfeedback_comments} a_c
          ON a.id = a_c.assignment 
          AND a_g.id = a_c.grade
          
        LEFT JOIN {context} ctx
          ON ctx.contextlevel = '$ctx_level'
          AND ctx.instanceid = cm.id
        LEFT JOIN {grading_areas} gr_a
          ON gr_a.contextid = ctx.id
          AND gr_a.component = 'mod_assign'
          AND gr_a.areaname = 'submissions'
        LEFT JOIN {grading_definitions} gr_def
          ON gr_def.areaid = gr_a.id
          AND gr_def.method = gr_a.activemethod
        LEFT JOIN {grading_instances} g_inst
          ON g_inst.itemid = a_g.id
          AND g_inst.definitionid = gr_def.id
          AND g_inst.raterid = a_g.grader
          AND g_inst.status IN ($active_status, $need_upd_status)  
        ";
        if ($this->_filter_get(static::USE_DEADLINE)){
            $from[] = "
            LEFT JOIN {assign_overrides} AS ao_group
                ON ao_group.assignid = a.id
                AND ao_group.groupid = gr.groupid
            LEFT JOIN {assign_overrides} AS ao_user
                ON ao_user.assignid = a.id
                AND ao_user.userid = u.id
            ";
        }
        return $from;
    }

    /**
     * Get parameters to add manual_grading_link to the action menu
     *
     * @return array
     */
    public function get_manual_grading_link_params(){
        list($url, $url_params, $class, $text, $link_attr) = parent::get_manual_grading_link_params();
        $url_params['action'] = 'grader';
        if ($this->_mm->studuserid){
            $url_params['userid'] = $this->_mm->studuserid;
        }
        return [$url, $url_params, $class, $text, $link_attr];
    }

    /**
     * @param $select
     * @param $from
     * @param $where
     * @param $groupby
     * @param $orderby
     * @param $having
     * @param $params
     */
    protected function _postcheck_data_params(&$select, &$from, &$where, &$groupby, &$orderby, &$having, &$params){
        if ($this->_filter_get(static::DRAFT_DETAILED_VIEW)){
            $select['timemodified'] = 'a_s.timemodified';
        }
        $select[static::ST_REOPENED] = $this->sql_get_condition_raw(static::ST_REOPENED);
    }

    /**
     * @param null $show_status
     *
     * @return \Closure|\string|null
     */
    protected function _get_personal_method($show_status=null){
        $show_status = $show_status ?? $this->_mm->get_show_status();
        if ($show_status == static::ST_DRAFT){
            return '_render_draft_table';
        }

        return parent::_get_personal_method($show_status);
    }

    /**
     * Render usual table by show & cm
     *
     * @param null $show_status
     * @param null $cm
     * @param null $filter
     * @param null $base_url
     *
     * @return string
     * @noinspection PhpUnused
     */
    protected function _render_draft_table($show_status=null, $cm=null, $filter=null, $base_url=null){
        $show_status = $show_status ?: static::ST_DRAFT;
        $MM = $this->_mm;
        $add_filter = [
            static::DRAFT_DETAILED_VIEW => true,
            static::GET_ST => [static::ST_MARKED],
        ];

        $filter = $filter ?: $MM->get_activity_filter(0, null, null, $add_filter);
        if ($warning = $this->_prerender($cm, $filter)){
            return $warning;
        }

        $mm_data = $this->get_activity_data();
        [$activity, $grade_item, $use_kica, $grade_fun] = $this->get_usual_cm_data();
        $cm = $MM->get_cm();

        $st_data = [];
        $d = function($key, $def='') use(&$st_data) {
            return NED::isset2($st_data, $key, $def);
        };

        $base_url = $MM->get_base_url($base_url);

        $o = $this->get_activity_header($grade_item, $use_kica);

        $table = new \html_table();
        $table->head = [get_string('name'), get_string('group')];
        $table->head[] = get_string('status');
        $table->head[] = NED::str('duedate');
        $table->head[] = NED::str('timemodified');
        $table->head[] = NED::str('grade_') . ($use_kica ? '*' : '');

        $st_menu = $this->get_student_function();
        $students = $MM->studuser ? [$MM->studuser] : $MM->students;
        foreach ($students as $student){
            $st_data = NED::isset2($mm_data, $student->id); // used by $d function
            if (!$st_data){
                continue;
            }
            $st_data = NED::stdClass2($st_data);
            $add_class = '';
            $cells = [];
            // username
            $cells[] = NED::cell($st_menu($student), 'username', ['data-sort-value' => fullname($student)]);
            // group name
            $groupsort = 'zzzzzzz';
            $grouplink = '-';
            if (isset($student->group->id)){
                $groupsort = $student->group->name;
                $base_url->param('group', $student->group->id);
                $grouplink = NED::link($base_url, $groupsort);
            }
            $cells[] = NED::cell($grouplink, 'groupname', ['data-sort-value' => $groupsort]);
            // status
            $status = NED::str($d(static::ST_MARKED, 0) ? static::ST_MARKED : 'notyetgraded');
            $statuses = [NED::div($status, 'mm-status')];

            if (NED::has_capability('editothersubmission', $cm->context)){
                $submit_link = NED::link([NED::PLUGIN_DIRS[NED::TT].'/submit_draft.php',
                                          ['id' => $cm->id, 'user' => $student->id]], 'submit_draft:link');
                $statuses[] = NED::div($submit_link, 'submit_draft');
            }

            $cells[] = NED::cell($statuses, 'status', ['data-sort-value' => $status]);
            // duedate
            $duedate = $d('duedate', 0);
            $cells[] = NED::cell(NED::ned_date($duedate), 'duedate', ['data-sort-value' => $duedate]);
            // time modified (last changes)
            $timemodified = $st_data->timemodified ?: 0;
            $cells[] = NED::cell(NED::ned_date($timemodified), 'submitted', ['data-sort-value' => $timemodified]);
            // grade
            $grade = $grade_fun($st_data);
            $cells[] = NED::cell($grade, 'user-grade', ['data-sort-value' => $grade == '-' ? -1 : $grade]);

            $table->data[] = NED::row($cells, $add_class);
        }

        $page_title = NED::str_check(["$show_status:pagetitle", $show_status]);
        $o .= NED::tag('h4', $page_title, 'mm_header mm_msg') .
            $this->render_mm_table($table, $show_status);

        return $o;
    }
}
