<?php

/**
 * @package    local_ned_controller
 * @subpackage marking_manager
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\marking_manager;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

/**
 * Class marking_manager_feedback
 *
 * @package local_ned_controller\marking_manager
 */
class marking_manager_feedback extends marking_manager_mod
{
    const SQL_USER_TIMEMODIFIED = 'fc.timemodified';
    const SQL_SUBMIT_TIME = self::SQL_USER_TIMEMODIFIED;
    const URL_MANUAL_GRADING = '';
    const SQL_TABLE_ALIAS = 'fe';
    const SQL_REQUIRE_ONLY_SUBMIT = '1';
    const HAVE_GRADES = false;

    /**
     * Return type of mod (static::MOD_*), and it's name of main DB-table
     * @return string
     */
    public function get_mod_type(){
        return static::MOD_FEEDBACK;
    }

    /**
     * Return condition by there name
     * @param string|array $name
     *
     * @return array|string
     */
    public function sql_get_condition_raw($name){
        if (!is_null($ans = parent::sql_get_condition_raw($name))){
            return $ans;
        }

        switch($name){
            case static::ST_UNSUBMITTED:
                return "fc.id IS NULL";
            case static::ST_UNMARKED:
                return NED::SQL_NONE_COND;
            case static::ST_SUBMITTED:
            case static::ST_MARKED:
                 return "fc.id IS NOT NULL";
            default:
                debugging("MM: Unknown condition '$name'");
                return NED::SQL_NONE_COND;
        }
    }

    /**
     * Return base FROM and JOIN statements
     *
     * @return array
     */
    public function sql_get_base_from_basis(){
        $from = [];
        $from []= "
        LEFT JOIN {feedback_completed} fc
            ON fc.feedback = fe.id
            AND fc.userid = u.id
        ";
        return $from;
    }
}
