<?php
/**
 * @package    local_ned_controller
 * @subpackage marking_manager
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\marking_manager;

use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

/**
 * Class marking_manager_quiz
 *
 * @package local_ned_controller\marking_manager
 */
class marking_manager_h5pactivity extends marking_manager_mod {

    const NON_PERSONAL_STATUSES = [];
    const SQL_SUBMIT_TIME = 'gg.timemodified';

    /**
     * Return type of mod (static::MOD_*), and it's name of main DB-table
     * @return string
     */
    public function get_mod_type(){
        return static::MOD_H5PACTIVITY;
    }

    /**
     * Return condition by there name
     * @param string|array $name
     *
     * @return array|string
     */
    public function sql_get_condition_raw($name){
        if (!is_null($ans = parent::sql_get_condition_raw($name))){
            return $ans;
        }

        switch($name){
            case static::ST_UNSUBMITTED:
                return "ha.id IS NULL";
            case static::ST_UNMARKED:
                return "har.rawscore IS NULL AND har.maxscore IS NOT NULL";
            case static::ST_SUBMITTED:
                return "ha.id IS NOT NULL";
            case static::ST_MARKED:
                return "har.rawscore IS NOT NULL";
            default:
                debugging("MM: Unknown condition '$name'");
                return NED::SQL_NONE_COND;
        }
    }

    /**
     * @param $select
     * @param $from
     * @param $where
     * @param $groupby
     * @param $orderby
     * @param $having
     * @param $params
     */
    protected function _postcheck_data_params(&$select, &$from, &$where, &$groupby, &$orderby, &$having, &$params){
        $where[] = 'ha.h5pactivityid IS NULL';
    }

    /**
     * Return base FROM and JOIN statements
     *
     * @return array
     */
    public function sql_get_base_from_basis(){
        $from = [];
        $from[] = " LEFT JOIN {h5pactivity_attempts} ha
            ON gg.userid = ha.userid 
            AND ha.h5pactivityid = h.id
            LEFT JOIN {h5pactivity_attempts_results} har
            ON ha.id = har.attemptid";

        return $from;
    }
}
