<?php

/**
 * @package    local_ned_controller
 * @subpackage marking_manager
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\marking_manager;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

/**
 * Class marking_manager_journal
 *
 * @package local_ned_controller\marking_manager
 */
class marking_manager_journal extends marking_manager_mod
{
    const SQL_USER_TIMEMODIFIED = 'je.modified';
    const SQL_SUBMIT_TIME = self::SQL_USER_TIMEMODIFIED;

    const URL_MANUAL_GRADING = '/mod/journal/report.php';

    /**
     * Return type of mod (static::MOD_*), and it's name of main DB-table
     * @return string
     */
    public function get_mod_type(){
        return static::MOD_JOURNAL;
    }

    /**
     * Return condition by there name
     * @param string|array $name
     *
     * @return array|string
     */
    public function sql_get_condition_raw($name){
        if (!is_null($ans = parent::sql_get_condition_raw($name))){
            return $ans;
        }

        $sql_not_overridden = $this::SQL_NOT_OVERRIDDEN;
        $sql_graded_by_overridden = $this::SQL_GRADED_BY_OVERRIDDEN;
        $sql_ungraded_by_overridden = $this::SQL_UNGRADED_BY_OVERRIDDEN;
        switch($name){
            case static::ST_UNSUBMITTED:
                return "je.id IS NULL";
            case static::ST_SUBMITTED:
                 return "je.id IS NOT NULL";
            case static::ST_UNMARKED:
                return "
                    ((je.id IS NOT NULL AND 
                        (je.modified > je.timemarked OR
                            (j.grade <> 0 AND (je.rating IS NULL OR je.rating < 0))
                        )
                    ) AND $sql_not_overridden)
                    OR $sql_ungraded_by_overridden
                ";
            case static::ST_MARKED:
                return "
                    (je.id IS NOT NULL AND je.modified <= je.timemarked AND 
                        ((j.grade = 0) OR
                            (je.rating IS NOT NULL AND je.rating > -1)
                        )
                    ) OR $sql_graded_by_overridden
                ";
            default:
                debugging("MM: Unknown condition '$name'");
                return NED::SQL_NONE_COND;
        }
    }

    /**
     * Return base FROM and JOIN statements
     *
     * @return array
     */
    public function sql_get_base_from_basis(){
        $from = [];
        $from []= "
        LEFT JOIN {journal_entries} je
            ON je.journal = j.id
            AND je.userid = u.id
        ";
        return $from;
    }
}
