<?php
/**
 * @package    local_ned_controller
 * @category   marking_manager
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\marking_manager;


/**
 * Trait mm_data_common
 *
 * Some keys, which you can get from MM data with using key BY:ACTIVITY
 *
 * @see \local_ned_controller\marking_manager\MM_base::BY_ACTIVITY
 *
 * @package local_ned_controller\marking_manager
 */
trait mm_data_by_activity {
    use mm_data_common;

    public $id;
    public $cmid; // course module id
    public $pos; // position in course, not by real numbers, but by order
    public $instance; // cm.instance = activity.id
    public $modid; // should be the same, as cm.instance
    public $name; // activity normal name
    public $modname; // $cm->modname = grade_items.itemmodule = activity table name
    public $visible; // bool, does it not hidden
    public $activity_completion; // bool, has any activity completion
    public $require_only_submit; // bool, submitting enough for completed
    public $grademax; // max grade from the grade_items.grademax

    public $is_summative; // bool, has summative tag
    public $is_formative; // bool, has formative tag
    public $is_midterm; // bool, has midterm tag
    public $is_term1; // bool, has Term 1 tag
    public $is_term2; // bool, has Term 2 tag
    public $is_final_exam; // bool, has Final Exam tag
    public $tags; // string, list of tags delimited by comma

    /** @see \local_ned_controller\marking_manager\MM_base::GET_PROXY_ENABLED */
    public $has_proxy; // bool, is this activity has proxy plugins

    // Record will have courseid, if there is none selected course id in MM options (which is unusual)
    public $courseid;
}
