<?php
/**
 * @package    local_ned_controller
 * @category   marking_manager
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\marking_manager;


/**
 * Trait mm_data_common
 *
 * Some keys, which you can get from MM data with using key BY_USER
 *
 * @see \local_ned_controller\marking_manager\MM_base::BY_USER
 *
 * @package local_ned_controller\marking_manager
 */
trait mm_data_by_user {
    use mm_data_common;

    public $userid;
    public $username;
    public $groupid;

    public $completed_successfully;
    public $completed_grade_successfully;
    public $completed_any; // has any completion (even failed) or grade
    public $completed;
    public $shouldpass;
    public $gt_shouldpass;
    public $gradepass; // grade_items.gradepass
    public $finalgrade;
    public $overridden; // grade_grades.overridden
    public $excluded; // grade_grades.excluded
    /**
     * Feedback data will be if filter has {@see \local_ned_controller\marking_manager\MM_base::GET_GRADE_COMMENT}
     * @var string $grade_feedback
     */
    public $grade_feedback;
    /**
     * @var int $grade_feedback_format - {@see FORMAT_MOODLE} and others FORMAT_*
     */
    public $grade_feedback_format;

    /**
     * Based on the {@see \grade_grade::get_dategraded()}
     * It's more like upgraded gg.timemodified, than really grade time - see original function or MDL-31379
     * @var int|null $grade_time
     */
    public $grade_time;
    public $gg_timemodified; // raw grade_grades.timemodified
    public $graderid; // grade_grades.usermodified

    /** @see \local_ned_controller\shared\db_util::sql_get_first_last_grade_join() */
    public $first_last_grade_time; // $grade_time but for the first grade in the last attempt

    public $attempt; // start from '0'
    public $submit_time;

    // If MM_base::USE_KICA
    public $knowledge;
    public $inquiry;
    public $communication;
    public $application;
    public $kica_zerograde; // if all KICA items = 0

    // If MM_base::USE_GT
    public $is_active;

    // ned_grade_controller data
    public $ngc_record;
    public $ngc_grade_type;
    public $ngc_grade_change;
    public $ngc_reason;
    public $ngc_status;
}
