<?php

/**
 * @package    local_ned_controller
 * @subpackage NED
 * @copyright  2020 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 *
 * @noinspection PhpUnused
 * @noinspection PhpUnusedParameterInspection
 */

use \local_ned_controller\ned_grade_controller as NGC;

defined('MOODLE_INTERNAL') || die();

require_once(__DIR__ . '/../lib.php');

/**
 * Event observers.
 */
class local_ned_controller_observer
{
    /**
     * User login event
     *
     * Deadline notification reset automatically, no need code for this
     * @see \local_ned_controller\deadline_notification::check_and_show_notifications()
     *
     * @param \core\event\user_loggedin $event
     */
    public static function user_loggedin(\core\event\user_loggedin $event){
        global $SESSION;
        $loggedinredirect = local_ned_controller_get_active_rules_data('loggedinredirect');
        if ($loggedinredirect){
            $SESSION->wantsurl = $loggedinredirect;
        }
    }

    public static function mod_assign_group_override_created(mod_assign\event\group_override_created $event){
        NGC::group_override_updated_event($event);
    }

    public static function mod_assign_group_override_updated(mod_assign\event\group_override_updated $event){
        NGC::group_override_updated_event($event);
    }

    public static function mod_assign_group_override_deleted(mod_assign\event\group_override_deleted $event){
        NGC::group_override_updated_event($event);
    }

    public static function mod_quiz_group_override_created(mod_quiz\event\group_override_created $event){
        NGC::group_override_updated_event($event);
    }

    public static function mod_quiz_group_override_updated(mod_quiz\event\group_override_updated $event){
        NGC::group_override_updated_event($event);
    }

    public static function mod_quiz_group_override_deleted(mod_quiz\event\group_override_deleted $event){
        NGC::group_override_updated_event($event);
    }

    public static function mod_assign_user_override_created(mod_assign\event\user_override_created $event){
        NGC::user_override_updated_event($event);
    }

    public static function mod_assign_user_override_updated(mod_assign\event\user_override_updated $event){
        NGC::user_override_updated_event($event);
    }

    public static function mod_assign_user_override_deleted(mod_assign\event\user_override_deleted $event){
        NGC::user_override_updated_event($event);
    }

    public static function mod_quiz_user_override_created(mod_quiz\event\user_override_created $event){
        NGC::user_override_updated_event($event);
    }

    public static function mod_quiz_user_override_updated(mod_quiz\event\user_override_updated $event){
        NGC::user_override_updated_event($event);
    }

    public static function mod_quiz_user_override_deleted(mod_quiz\event\user_override_deleted $event){
        NGC::user_override_updated_event($event);
    }

    public static function mod_assign_assessable_submitted(\mod_assign\event\assessable_submitted $event){
        NGC::assign_submission_submitted_event($event);
    }

    public static function ned_assign_submission_removed(\local_ned_controller\event\submission_removed $event){
        NGC::assign_submission_removed_event($event);
    }
}
