<?php
/**
 * @package    local_ned_controller
 * @subpackage custom_ned_menu
 * @category   NED
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\output\custom_ned_menu;

/**
 * Class menu_course_header
 * Used by the {@see \format_ned::course_header()} for rendering header menu from the custom_ned_menu item
 *
 * @package local_ned_controller\output\custom_ned_menu
 */
class custom_ned_menu_header implements \renderable, \templatable
{
    /** @var custom_ned_menu */
    protected $_menu;

    /**
     * menu_course_header constructor.
     *
     * @param custom_ned_menu $menu
     */
    public function __construct($menu){
        $this->_menu = $menu;
    }

    /**
     * Function to export the renderer data in a format that is suitable for a
     * mustache template. This means:
     * 1. No complex types - only stdClass, array, int, string, float, bool
     * 2. Any additional info that is required for the template is pre-calculated (e.g. capability checks).
     *
     * @param \renderer_base $output Used to do a final render of any components that need to be rendered for export.
     *
     * @return object|array|null
     */
    public function export_for_template(\renderer_base $output){
        $menu = $this->get_menu();
        if ($menu && $menu->is_use_units()){
            $menu->init_current_active_item();
            return $menu;
        }

        return null;
    }

    /**
     * @return custom_ned_menu
     */
    public function get_menu(){
        return $this->_menu;
    }
}
