<?php
/**
 * Plotly value class for plotly class
 *
 * @package    local_ned_controller
 * @subpackage shared
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
namespace local_ned_controller\output\plotly;


/**
 * Class plotly_value
 *
 * @package local_ned_controller\output\plotly
 */
class plotly_value
{
    public $value;
    public $label = '';
    public $color = '';

    /**
     * plotly_value constructor.
     *
     * @param        $value
     * @param string $label
     * @param string $color
     */
    public function __construct($value, $label='', $color=''){
        $this->value = $value;
        $this->label = $label;
        $this->color = $color;
    }

    /**
     * @param $color
     */
    public function set_color($color){
        $this->color = $color;
    }

    /**
     * @param     $r
     * @param     $g
     * @param     $b
     * @param int $a
     */
    public function set_rgba($r, $g, $b, $a=1){
        $this->color = "rgba($r, $g, $b, $a)";
    }

    /**
     * @param bool $hide_label
     * @param null $set_color
     */
    public function set_invisible($hide_label=true, $set_color=null){
        if ($set_color){
            $this->set_color($set_color);
        } else {
            $this->set_rgba(0, 0,0, 0);
        }
        if ($hide_label){
            $this->label = '';
        }
    }
}
