<?php
/**
 * @package    local_ned_controller
 * @subpackage shared
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\shared;
use local_ned_controller\shared_lib as CTRL;

defined('MOODLE_INTERNAL') || die();

/**
 * Trait theme
 * Functions for theme plugins
 *
 * @package local_ned_controller\shared
 */
trait theme {
    use base_trait;

    /**
     * @return array
     */
    static public function get_myprofile_categories(){
        global $USER;
        $tree = \core_user\output\myprofile\manager::build_tree($USER, true);
        $categories = [];
        foreach ($tree->categories as $category){
            $title = $category->title;
            $categories[$category->name] = empty($title) ? $category->name : $title;
        }
        return $categories;
    }

    /**
     * @param bool $fullname
     *
     * @return array
     */
    static public function get_possible_videofields($fullname=true){
        $choices = [
            -1 => CTRL::str('setting:videofield:automatic'),
            0 => get_string('none')
        ];
        $profile_fields = profile_get_custom_fields();
        foreach ($profile_fields as $field){
            if ($field->datatype == 'text'){
                $choices[$field->id] = $fullname ? "$field->name {{$field->shortname}}" : $field->shortname;
            }
        }

        return $choices;
    }

    /**
     * @param string $option_name
     */
    static public function change_videofield($option_name=''){
        global $DB;
        if ($option_name != 's_' . static::$PLUGIN_NAME . '_videofield'){
            return;
        }

        $config = static::get_config();
        if ($config->videofield == -1){
            $plugin_name = static::str('pluginname');
            $field_name = 'videofield';
            $field_full_name = CTRL::str('videofield:fieldname');
            $categories = profile_list_categories();
            $fields = profile_get_custom_fields();

            // create new category & field if necessary
            $categ_id = 0;
            foreach ($categories as $cid => $category){
                if ($category == $plugin_name){
                    $categ_id = $cid;
                    break;
                }
            }

            if (!$categ_id){
                // create new category // got this from /user/profile/definelib.php: profile_edit_category
                $data = (object) ['name' => $plugin_name, 'sortorder' => count($categories) + 1];
                $categ_id = $DB->insert_record('user_info_category', $data, true);
                $createdcategory = $DB->get_record('user_info_category', ['id' => $categ_id]);
                \core\event\user_info_category_created::create_from_category($createdcategory)->trigger();
            }

            $field_shortname = [];
            foreach ($fields as $field){
                $field_shortname[$field->shortname] = true;
            }

            $field_new_name = $field_name;
            $i = 2;
            while (isset($field_shortname[$field_new_name])){
                $field_new_name = $field_name . $i++;
            }

            if ($i > 2){
                $field_full_name = $field_full_name . ' ' . ($i-1);
            }

            // create field // got this from /user/profile/definelib.php: define_save
            $data = (object)[
                'shortname' => $field_new_name,
                'name' => $field_full_name,
                'categoryid' => $categ_id,
                'description' => CTRL::str('videofield:fielddescription', $plugin_name),
                'descriptionformat' => '1',
                'defaultdata' => '',
                'datatype' => 'text',
                'param1' => 100,
                'param2' => 10000,
                'param3' => 0,
                'param4' => '',
                'param5' => ''
            ];
            $data->sortorder = $DB->count_records(C::TABLE_USER_INFO_FIELD, ['categoryid' => $data->categoryid]) + 1;
            $field_id = $DB->insert_record(C::TABLE_USER_INFO_FIELD, $data);
            $field = $DB->get_record(C::TABLE_USER_INFO_FIELD, ['id' => $field_id]);
            \core\event\user_info_field_created::create_from_field($field)->trigger();

            static::set_config('videofield', $field_id);
        }
    }

    /**
     * @param \core_user\output\myprofile\tree $tree
     * @param                                  $user
     * @param                                  $iscurrentuser
     * @param                                  $course
     */
    static public function myprofile_navigation(\core_user\output\myprofile\tree $tree, $user, $iscurrentuser, $course) {
        global $PAGE;
        if ($PAGE->theme->name != static::$PLUGIN){
            return;
        }

        $config = static::get_config();

        if (!isset($config->videofield) || $config->videofield < 1){
            return;
        }

        $choices = static::get_possible_videofields(false);
        if (!isset($choices[$config->videofield])){
            static::set_config('videofield', 0);
            return;
        }

        $usercustomfields = profile_user_record($user->id);
        if (!isset($usercustomfields->{$choices[$config->videofield]})){
            return;
        }

        $link = $usercustomfields->{$choices[$config->videofield]};
        if(!url_appears_valid_url($link)){
            return;
        }

        $content = format_text(\html_writer::link($link, "$user->firstname $user->lastname video"), FORMAT_HTML);
        if (empty($content)){
            return;
        }

        $categ_name = "theme-categ-videofield";
        $categ_title = CTRL::str('videofield:node_category_name');
        $field_name = "theme-field-videofield";

        $category = new \core_user\output\myprofile\category($categ_name, $categ_title, 'contact');
        /** @noinspection PhpDynamicFieldDeclarationInspection */
        $category->force_order = 2;
        $tree->add_category($category);

        $node = new \core_user\output\myprofile\node($categ_name, $field_name, '', null, null, $content, null, $field_name);
        $tree->add_node($node);
    }

}