<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Update Deadline Notifications task - Adhoc
 *
 * @package    local_ned_controller
 * @subpackage task
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\task;
use local_ned_controller\deadline_notification as DN;

defined('MOODLE_INTERNAL') || die();

/**
 * Class adhoc_deadline_notification_update
 *
 * @package local_ned_controller\task
 */
class adhoc_deadline_notification_update extends base_adhoc_task {
    use base_task;


    /**
     * Do task job without any checks
     *
     * @param base_task|array|null $task_or_data
     *
     * @return void
     */
    static public function do_job($task_or_data=[]){
        if (static::is_maple_warning()) return;

        $d = function(...$args){
            static::print(...$args);
        };
        DN::check_records_by_course(0, $d);
    }
}
