<?php

/**
 * @package    local_ned_controller
 * @subpackage task
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\task;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die;

/**
 * Class disposable_adhoc_task
 * You can use this task to call some custom function later, if you not need it regularly
 *
 * @package local_ned_controller\task
 */
class disposable_adhoc_task extends base_adhoc_task {
    use base_task;

    /**
     * Do task job without any checks
     *
     * @param base_task|array|null task
     *
     * @return void
     */
    static public function do_job($task_or_data=[]){
        $data = static::get_data_from_task_or_data($task_or_data);
        if (!empty($data['callback'])){
            $callback = $data['callback'];
            static::print("Try to call $callback");
        } elseif (!empty($data['classname']) && !empty($data['methodname'])){
            $classname = $data['classname'];
            $methodname = $data['methodname'];
            $callback = [$classname, $methodname];
            static::print("Try to call $classname::$methodname");
        } else {
            static::print("There is nothing to call, pass");
            return;
        }

        if (!empty($data['required_files'])){
            foreach ($data['required_files'] as $file){
                $res_file = NED::require_file($file) ? '+' : '-';
                static::print("Require file $file: $res_file");
            }
        }

        $params = $data['params'] ?? [];
        call_user_func_array($callback, $params);
    }

    /**
     * Add new task
     *
     * @param string $callback
     * @param string $classname
     * @param string $methodname
     * @param array  $params
     * @param int    $time_delay
     * @param null|static $task
     * @param array  $required_files
     *
     * @return base_adhoc_task
     */
    static public function add_new_job($callback='', $classname='', $methodname='', $params=[], $time_delay=0, $task=null, $required_files=[]){
        if (empty($callback) && (empty($classname) || empty($methodname))){
            static::print('You need to set $callback or $classname with $methodname');
            return null;
        }

        $required_files = NED::val2arr($required_files);
        $data = ['callback' => $callback, 'classname' => $classname, 'methodname' => $methodname,
            'params' => $params, 'required_files' => $required_files];

        $task = $task ?? new static();
        $old_data = $task->get_custom_data();
        $old_data = $old_data ? (array)$old_data : [];
        $task->set_custom_data(array_merge($old_data, $data));

        return static::_add_new_job($task, $time_delay);
    }
}
