<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Update Grade Controller task
 *
 * @package    local_ned_controller
 * @subpackage task
 * @category   NED
 * @copyright  2021 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\task;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

/**
 * Class ned_grade_controller_update
 *
 * @package local_ned_controller\task
 */
class ned_grade_controller_update extends \core\task\scheduled_task {
    use base_task;

    static protected $_added_tasks = 0;

    /**
     * Do task job without any checks
     *
     * @param base_task|array|null task
     *
     * @return void
     */
    static public function do_job($task_or_data=[]){
        static::$_added_tasks = 0;
        $config = NED::get_config();
        if (!$config->cron_ngc_enable){
            static::print('cron_ngc is not enable, pass.');
            return;
        }

        if ($config->cron_ngc_update_enable){
            $res = (bool)adhoc_ned_grade_controller_update::just_add_new_job_without_doubles();
            static::$_added_tasks += (int)$res;
        } else {
            static::print('adhoc_ned_grade_controller_update is not enable, skip');
        }

        if ($config->cron_ngc_missed_deadlines_enable){
            $res = (bool)adhoc_cron_ngc_missed_deadlines::add_new_job(static::$_added_tasks, null, true);
            static::$_added_tasks += (int)$res;
        } else {
            static::print('adhoc_cron_ngc_missed_deadlines is not enable, skip');
        }

        if ($config->cron_ngc_late_submissions_enable){
            $res = (bool)adhoc_cron_ngc_late_submissions::add_new_job(static::$_added_tasks, null, true);
            static::$_added_tasks += (int)$res;
        } else {
            static::print('adhoc_cron_ngc_late_submissions is not enable, skip');
        }

        if ($config->cron_ngc_fixed_submissions_enable){
            $res = (bool)adhoc_cron_ngc_fixed_submissions::add_new_job(static::$_added_tasks, null, true);
            static::$_added_tasks += (int)$res;
        } else {
            static::print('adhoc_cron_ngc_fixed_submissions is not enable, skip');
        }
    }
}
