<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Update activity RAID.
 *
 * @package     local_ned_controller
 * @category    task
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\task;

defined('MOODLE_INTERNAL') || die();

/**
 * Class update_activity_raid
 *
 * @package local_ned_controller\task
 */
class update_activity_raid extends \core\task\scheduled_task {

    /**
     * Get a descriptive name for this task (shown to admins).
     *
     * @return string
     */
    public function get_name() {
        return get_string('updateactivityraid', 'local_ned_controller');
    }

    /**
     * Do the job.
     * Throw exceptions on errors (the job will be retried).
     */
    public function execute() {
        global $DB;

        if (!$field = $DB->get_record('customfield_field', ['shortname' => 'raid'])) {
            return true;
        }

        if (!$field2 = $DB->get_record('customfield_field', ['shortname' => 'ghs_report'])) {
            return true;
        }

        if (!$field3 = $DB->get_record('customfield_field', ['shortname' => 'regt'])) {
            return true;
        }

        $time = time();

        $sql = "SELECT cm.id, c.shortname, cx.id contexid,
                       CASE
                           WHEN m.name = 'assign' THEN (SELECT name FROM mdl_assign WHERE id = cm.instance)
                           WHEN m.name = 'forum' THEN (SELECT name FROM mdl_forum  WHERE id = cm.instance)
                       WHEN m.name = 'quiz' THEN (SELECT name FROM mdl_quiz WHERE id = cm.instance)	 
                       ELSE ''
                       END AS activity, 
	                   d.id dataid
                  FROM {course_modules} cm
	              JOIN {modules} m ON cm.module = m.id
                  JOIN {course} c ON cm.course = c.id
                  JOIN {context} cx ON cm.id = cx.instanceid AND cx.contextlevel = ?
             LEFT JOIN {customfield_data} d ON cm.id = d.instanceid AND d.fieldid = ?
                 WHERE cm.deletioninprogress = 0
                   AND m.name IN ('assign', 'quiz', 'forum')
                   AND cm.course NOT IN (SELECT instanceid FROM {customfield_data} cd WHERE fieldid = ? AND intvalue = 1)";

        $rs = $DB->get_recordset_sql($sql, [CONTEXT_MODULE, $field->id, $field2->id]);

        foreach ($rs as $activity) {
            $data = new \stdClass();
            $data->charvalue = substr($activity->shortname, 0, 5) . ' ' . $activity->activity;
            $data->value = $data->charvalue;

            if ($activity->dataid) {
                // Update;
                $data->id = $activity->dataid;
                $data->timemodified = $time;
                $DB->update_record('customfield_data', $data);
            } else {
                // Insert.
                $data->fieldid = $field->id;
                $data->instanceid = $activity->id;
                $data->valueformat = 0;
                $data->contextid = $activity->contexid;
                $data->timecreated = $time;
                $data->timemodified = $time;
                $DB->insert_record('customfield_data', $data);
            }
        }

        $rs->close();

        // Rosedale Estimate Grading Time.
        $sql = "SELECT d.charvalue, COUNT(1) numof
			      FROM {course_modules} cm
		          JOIN {modules} m ON cm.module = m.id
			      JOIN {course} c ON cm.course = c.id
			      JOIN {context} cx ON cm.id = cx.instanceid AND cx.contextlevel = ?
             LEFT JOIN {customfield_data} d ON cm.id = d.instanceid AND d.fieldid = ?
		         WHERE cm.deletioninprogress = 0
			       AND m.name IN ('assign', 'quiz', 'forum')
		           AND d.charvalue <> ''
			       AND cm.course NOT IN (SELECT instanceid FROM {customfield_data} cd WHERE fieldid = ? AND intvalue = 1)
		      GROUP BY d.charvalue		
		        HAVING numof > 1";
        $rs = $DB->get_recordset_sql($sql, [CONTEXT_MODULE, $field->id, $field2->id]);

        foreach ($rs AS $raid) {
            $sql = "SELECT cm.id, cx.id contexid, d2.id dataid, d2.intvalue
			          FROM {course_modules} cm
		              JOIN {modules} m ON cm.module = m.id
			          JOIN {course} c ON cm.course = c.id
			          JOIN {context} cx ON cm.id = cx.instanceid AND cx.contextlevel = ?
                      JOIN {customfield_data} d ON cm.id = d.instanceid AND d.fieldid = ?
                 LEFT JOIN {customfield_data} d2 ON cm.id = d2.instanceid AND d2.fieldid = ?
		             WHERE cm.deletioninprogress = 0
			           AND m.name IN ('assign', 'quiz', 'forum')
			           AND cm.course NOT IN (SELECT instanceid FROM mdl_customfield_data cd WHERE fieldid = ? AND intvalue = 1)
			           AND d.charvalue = ?";
            if (!$regts = $DB->get_records_sql($sql, [CONTEXT_MODULE, $field->id, $field3->id, $field2->id, $raid->charvalue])) {
                continue;
            }

            $values = [];

            foreach ($regts as $regt) {
                if (!is_null($regt->intvalue) && $regt->intvalue != '') {
                    $values[$regt->intvalue] = $regt->intvalue;
                }
            }

            if (count($values) == 1) {
                $value = reset($values);
                foreach ($regts as $regt) {
                    if (is_null($regt->intvalue) || $regt->intvalue === '') {
                        $data = new \stdClass();
                        $data->intvalue = $value;
                        $data->value = $value;

                        if ($regt->dataid) {
                            // Update;
                            $data->id = $regt->dataid;
                            $data->timemodified = $time;
                            $DB->update_record('customfield_data', $data);
                        } else {
                            // Insert.
                            $data->fieldid = $field3->id;
                            $data->instanceid = $regt->id;
                            $data->valueformat = 0;
                            $data->contextid = $regt->contexid;
                            $data->timecreated = $time;
                            $data->timemodified = $time;
                            $DB->insert_record('customfield_data', $data);
                        }
                    }
                }
            }
        }

        $rs->close();
    }
}