<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Update Plugin Info.
 *
 * @package     local_ned_controller
 * @category    task
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_ned_controller\task;
use local_ned_controller\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();
NED::require_file('~/lib.php');

/**
 * Class update_plugin_info
 *
 * @package local_ned_controller\task
 */
class update_plugin_info extends \core\task\scheduled_task {
    use base_task;

    /**
     * Get a descriptive name for this task (shown to admins).
     *
     * @return string
     */
    public static function get_task_name() {
        return NED::str('updatenedpluginsinfo');
    }

    /**
     * Do task job without any checks
     * @param array|object|static|null $task_or_data
     *
     * @return void
     */
    public static function do_job($task_or_data=[]){
        local_ned_controller_update_plugin_info();
    }
}