<?php
/**
 * @package    local_ned_controller
 * @category   NED
 * @copyright  2022 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_ned_controller\shared_lib as NED;

if (!isset($CFG)){
    require_once('../../config.php');
}

/**
 * Check course-module type and redirect to its grading page
 * Do almost none checks, as them will be done by the point page
 */

$cmid = optional_param(NED::PAR_CM, 0, PARAM_INT);
if (empty($cmid)){
    $cmid = optional_param(NED::PAR_ID, 0, PARAM_INT);
}

$courseid = optional_param(NED::PAR_COURSE, 0, PARAM_INT);
$userid = optional_param(NED::PAR_USER, 0, PARAM_INT);
$cached_groupid = optional_param(NED::PAR_GROUP, 0, PARAM_INT);

$cm = $cmid ? NED::get_cm_by_cmid($cmid, $courseid) : null;
if (empty($cm)){
    throw new moodle_exception('invalidcoursemodule', 'error');
}

$params = ['id' => $cm->id, 'course' => $cm->course];
$redirect_url = null;
$default_redirect = function() use (&$cm){
    $url = $cm->url;
    if (!empty($url)){
        redirect(new \moodle_url($url));
        die;
    }

    NED::redirect(NED::url(NED::PAGE_COURSE, ['id' => $cm->course]), "Activity $cm->modname has not grading page");
    die;
};

if (empty($userid)){
    $default_redirect();
    die;
}
$params['user'] = $userid;

$courseid = $cm->course;
$groups = NED::get_user_groupids($courseid, $userid);
if (empty($groups)){
    $groupid = 0;
} elseif (count($groups) == 1){
    $groupid = reset($groups);
} else {
    if (!$cached_groupid){
        $cached_groupid = NED::get_cached_groupid($courseid);
    }
    if ($cached_groupid === 0){
        $groupid = 0;
    } elseif (!in_array($cached_groupid, $groups)) {
        $groupid = reset($groups);
    } else {
        $groupid = $cached_groupid;
    }
}
$params['group'] = $groupid;

switch ($cm->modname){
    case NED::ASSIGN:
        $params['action'] = 'grader';
        $params['userid'] = $userid;
        unset($params['user']);

        /**
         * Reset assign view settings
         * @see \assign_grading_table::__construct
         * @see \flexible_table::initialise_table_preferences
         */
        $assign_grading_table_id = 'mod_assign_grading-' . $cm->context->id;
        unset_user_preference('flextable_'.$assign_grading_table_id);

        $redirect_url = NED::url($cm->url, $params);
        break;
    case NED::QUIZ:
        $use_KQ = optional_param(NED::PAR_USE_KICA_QUIZ, false, PARAM_BOOL);
        if ($use_KQ){
            $redirect_url = NED::kq_get_kica_quiz_grader_link($cm, $userid, $courseid);
            if ($redirect_url) break;
        }

        $q_attempts = quiz_get_user_attempts($cm->instance, $userid, 'all');
        if (empty($q_attempts)){
            $params['mode'] = 'grading';
            $redirect_url = new \moodle_url("/mod/quiz/report.php", $params);
        } else {
            $params = [];
            $params['attempt'] = end($q_attempts)->id;
            $redirect_url = new \moodle_url("/mod/quiz/review.php", $params);
        }
        break;
    case NED::FORUM:
        $vaultfactory = \mod_forum\local\container::get_vault_factory();
        $forum = $vaultfactory->get_forum_vault()->get_from_course_module_id($cm->id);
        if ($forum->get_rating_aggregate() <> RATING_AGGREGATE_NONE){
            $discussions = \forum_get_user_involved_discussions($cm->instance, $userid) ?: [];
            if (count($discussions) == 1){
                $params = [];
                $params['d'] = reset($discussions)->id;
                $redirect_url = new \moodle_url("/mod/forum/discuss.php", $params);
            }
        } else {
            $redirect_url = $cm->url;
        }
        break;
    case NED::H5PACTIVITY:
        $params['id'] = $cm->instance;
        $redirect_url = new \moodle_url("/mod/h5pactivity/report.php", $params);
        break;
}

if (!empty($redirect_url)){
    NED::redirect($redirect_url);
    die;
}

$default_redirect();
die;
