<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Plugins overview
 *
 * @package     local_package
 * @category    string
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

use local_ned_controller\shared_lib as NED;

require_once($CFG->dirroot . '/local/ned_controller/local_lib.php');
require_once($CFG->libdir . '/formslib.php');

/**
 * Class local_ned_controller_settings_form
 */
class local_ned_controller_settings_form extends moodleform {

    protected function definition() {

        $mform = $this->_form;
        $add_button = function($name, $url, $text='') use ($mform){
            $text = !empty($text) ? $text : $name;
            $mform->addElement('static', $name, NED::link($url, $text, 'btn btn-primary'));
        };

        $add_settings = function($from_elements, $prefix='', $use_header_prefix=false) use (&$mform) {
            foreach ($from_elements as $header => $elements){
                $elem_prefix = $prefix . $header;
                $header_text = $elements['name'] ?? $elem_prefix;
                $mform->addElement('header', 'local_ned_controller_' . $elem_prefix . '_heading', NED::str($header_text));
                foreach ($elements as $name => $elem_data){
                    if ($name == 'name'){
                        continue;
                    }

                    if (is_array($elem_data)){
                        $type = $elem_data['type'] ?? $elem_data[0];
                    } else {
                        $type = $elem_data;
                    }

                    $text = $prefix . $name;
                    $elem_name = $use_header_prefix ? ($elem_prefix.$name) : ($prefix.$name);
                    $str_text = NED::str($text);
                    $str_desc = NED::str_check($text . '_help', null, '');
                    switch($type){
                        case 'advcheckbox':
                            $str_checkbox_desc = NED::str_check($text . '_desc', null, '');
                            $mform->addElement('advcheckbox', $elem_name, $str_text, $str_checkbox_desc);
                            break;
                        case 'selectyesno':
                            $mform->addElement('selectyesno', $elem_name, $str_text);
                            break;
                        case 'text':
                            $mform->addElement('text', $elem_name, $str_text);
                            $mform->setType($elem_name, $elem_data[1] ?? PARAM_RAW);
                            break;
                        case 'date_selector':
                            $mform->addElement('date_selector', $elem_name, $str_text);
                            if (!empty($elem_data[1])){
                                $mform->setDefault($elem_name, $elem_data[1]);
                            }
                            break;
                    }
                    if (!empty($str_desc)){
                        $mform->addHelpButton($elem_name, $text, NED::$PLUGIN_NAME);
                    }
                }
            }

        };

        $from_elements = [
            // General
            'general' => [
                'redirecttodraft' => 'advcheckbox', // Redirect to draft
                'ned_school_year_start' => ['date_selector', make_timestamp(2022, 9, 1)],
            ],
            'gradecontroller' => [
                'cron_ngc_enable' => 'selectyesno',
                'cron_ngc_time' => ['text', PARAM_INT],
                'cron_ngc_delay' => ['text', PARAM_INT],
                'cron_ngc_update_enable' => 'selectyesno',
                'cron_ngc_missed_deadlines_enable' => 'selectyesno',
                'cron_ngc_late_submissions_enable' => 'selectyesno',
                'cron_ngc_fixed_submissions_enable' => 'selectyesno',
            ],
        ];
        $add_settings($from_elements);


        // Quick links in the course header.
        $mform->addElement('header', 'categoryicons_heading',
            NED::str('categoryicons'));
        $mform->addElement('textarea', 'categoryicons', NED::str('categoryiconsformat'), 'wrap="virtual" rows="5" cols="60"');

        $description = NED::str('categoryiconsformat') . NED::str('categoryiconscategory'). ', '.
            NED::str('categoryiconsfontawesome') . NED::str('categoryiconssemi');
        $mform->addElement('static', 'categoryiconsformatdesc', '', $description);

        $mform->addElement('header', 'local_ned_controller_themerulesheader_heading', NED::str('themerulesheader'));

        // Theme customization
        $add_button('managerules', NED::url('/rules_edit.php'));
        // Pop-up notifications
        $add_button('popupnotifications', NED::url('/notifications_edit.php'));

        // 'header' => [elements]
        $from_elements = [
            // Quick links in the theme rules header.
            'courseheader' => [
                'name' => 'quicklinkscourseheaderboosttheme',
                'manualenrollment' => 'advcheckbox',    // Manual enrollment.
                'courseparticpants' => 'advcheckbox',   // Course participants.
            ],
            // Quick links in next to the course name.
            'coursename' => [
                'name' => 'quicklinkscoursenamenedformat',
                'editsettings' => 'advcheckbox',        // Edit settings.
                'manualenrollment' => 'advcheckbox',    // Manual enrollment.
                'courseparticpants' => 'advcheckbox',   // Course participants.
                'nedprogressreport' => 'advcheckbox',   // C Progress report.
                'nedmarkingmanager' => 'advcheckbox',   // C Marking Manager.
                'nedstudentmenu' => 'advcheckbox',      // C Student Menu.
                'gradebook' => 'advcheckbox'            // Gradebook.
            ]
        ];

        $add_settings($from_elements, 'quicklinks', true);

        $this->add_action_buttons();
    }
}
