<?php

/**
 * This file is the entry point to the ned_assign module. All pages are rendered from here
 * This page based on /mod/assign/view.php
 *
 * @package local_ned_controller
 */

use local_ned_controller\mod_assign\assign as ned_assign;
use local_ned_controller\shared_lib as NED;

require_once('../../config.php');
NED::require_file('/mod/assign/locallib.php');

$id = required_param('id', PARAM_INT);

[$course, $cm] = NED::get_course_and_cm_from_cmid($id, 'assign');
if (!$course || !$cm) {
    throw new moodle_exception('invalidcoursemodule', 'error');
}

require_login($course, true, $cm);

$context = context_module::instance($cm->id);

require_capability('mod/assign:view', $context);
$assign = new ned_assign($context, $cm, $course);
$urlparams = [
    'id' => $id,
    'action' => optional_param('action', '', PARAM_ALPHA),
    'rownum' => optional_param('rownum', 0, PARAM_INT),
    'useridlistid' => optional_param('useridlistid', $assign->get_useridlist_key_id(), PARAM_ALPHANUM)
];

if (!$assign->is_need_substitute_page()){
    NED::redirect(new moodle_url(ned_assign::MOODLE_URL, $urlparams));
}

$url = new moodle_url(ned_assign::URL, $urlparams);
$PAGE->set_url($url);
$PAGE->add_body_class('path-mod-assign path-blocks-NED');

// Update module completion status.
$assign->set_module_viewed();

// Apply overrides.
$assign->update_effective_access($USER->id);

// Get the assign class to
// render the page.
echo $assign->view(optional_param('action', '', PARAM_ALPHA));
