<?php
/**
 * Plugins overview
 *
 * @package     local_ned_controller
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_ned_controller as C;
use local_ned_controller\ned_notifications as NN;
use local_ned_controller\shared_lib as NED;

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once(__DIR__.'/lib.php');

/*
 * id = -1 - list of notifications
 * id = 0 - new notification
 * other - edit notification
 */
$id = optional_param('id', -1, PARAM_INT);

// Security.
$context = context_system::instance();
require_login();
require_capability('moodle/site:config', $context);

// Page boilerplate stuff.
$url_params = $id != -1 ? ['id' => $id] : [];
$url = NED::url('~notifications_edit.php', $url_params);
$PAGE->set_context($context);
$PAGE->set_url($url);
$PAGE->set_pagelayout('admin');
$title = NED::str('popupnotifications');
$PAGE->set_title($title);
$PAGE->set_heading($title);
$output = ''; // Don't add header before we have possibility of redirect

// Set up the form.
$mform = new C\form\notifications_edit_form($url, ['id' => $id],'post',
    '', ['class'=>'local_ned_controller_notifications_edit_form']);
if ($mform->is_cancelled()) {
    $url->remove_params('id');
    redirect($url);
} elseif ($data = $mform->get_data()) {
    if ($mform->is_submitted()) {
        $name = $data->name;
        if (isset($data->submitbutton)) {
            $new_id = NN::save_form_data($data);
            $url->remove_params('id');
            NED::redirect($url, NED::str($new_id != $id ? 'notifications:created' : 'notifications:updated', $name), null,
                \core\output\notification::NOTIFY_SUCCESS);
        } elseif (isset($data->saveasbutton)) { // save as copy, don't chane the original one
            $data->id = 0;
            NN::save_form_data($data);
            $url->remove_params('id');
            NED::redirect($url, NED::str('notifications:copied', $name), null,
                \core\output\notification::NOTIFY_SUCCESS);
        } elseif (isset($data->deletebutton)) {
            NN::delete_notification($id);
            $url->remove_params('id');
            NED::redirect($url, NED::str('notifications:removed', $name), null,
                \core\output\notification::NOTIFY_SUCCESS);
        }
    }
}

// Edit notification: load existing data & update form
if ($id > 0){
    $data = NN::load_data_for_form($id);
    if (!$data){
        $url->param('id', 0);
        redirect($url);
    }

    $mform->update($data);
}

// Show list of Notifications
if ($id == -1) {
    $output .= \html_writer::div(NED::str('notifications_desc'), 'notifications-desc');

    $table = NN::get_table_view();
    if (empty($table->data)){
        $output .= \html_writer::div(NED::str('no_notifications'), 'no-notifications');
    } else {
        $output .= \html_writer::table($table);
    }

    $output .= NED::link([$url, ['id' => 0]],'notifications:add','btn btn-primary');
    $cancel_url = local_ned_controller_get_setting_local_urlpath('ned_controller');
    $output .= NED::link([$cancel_url], 'close','btn btn-default btn-secondary note-button-reset');
} else {
    // Show form for add or edit Notification
    $output .= $mform->draw();
}

echo $OUTPUT->header() . \html_writer::div($output, 'wrapper-notifications') . $OUTPUT->footer();
