<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

require_once(dirname(dirname(dirname(__FILE__))) . '/config.php');
require_once($CFG->dirroot . '/local/ned_controller/lib.php');
require_once($CFG->dirroot . '/local/ned_controller/rules_edit_form.php');

//get id rules
$id = optional_param('id', 0, PARAM_INT);

// Security.
$context = context_system::instance();
require_login();
require_capability('moodle/site:config', $context);

// Page boilerplate stuff.
$url = new moodle_url('/local/ned_controller/rules_edit.php');
$PAGE->set_context($context);
$PAGE->set_url($url);
$PAGE->set_pagelayout('admin');
$title = get_string('rules', 'local_ned_controller');
$PAGE->set_title($title);
$PAGE->set_heading($title);
$sucessmsg = '';
$values = [];
$ruleclass = new \local_ned_controller\rule();
// Set up the form.
$mform = new local_ned_controller_rules_edit_form($url, ['id' => $id],'post','',['class'=>'local_ned_controller_rules_edit_form']);
{
    if ($mform->is_cancelled()) {
        redirect($url);
    } else {
        if ($data = $mform->get_data()) {
            if ($mform->is_submitted()) {
                if (isset($data->submitbutton)) {
                    $data->timemodified = time();
                    if (empty($data->id)) {
                        //set timecreated
                        $data->timecreated = $data->timemodified;
                        //insert rule in table
                        $id = $DB->insert_record('local_ned_controller_rules', $data);
                        //save file
                        $data = file_postupdate_standard_filemanager($data, 'logo', ['subdirs' => 0], $context,
                                'local_ned_controller', 'logo', $id);
                        $data = file_postupdate_standard_filemanager($data, 'compactlogo', ['subdirs' => 0], $context,
                                'local_ned_controller', 'compactlogo', $id);
                        redirect($url, get_string('rulecreated', 'local_ned_controller'), 0,
                                \core\output\notification::NOTIFY_SUCCESS);
                    } else {
                        //update rule
                        $DB->update_record('local_ned_controller_rules', $data);
                        //save file
                        $data = file_postupdate_standard_filemanager($data, 'logo', ['subdirs' => 0], $context,
                                'local_ned_controller', 'logo', $data->id);
                        $data = file_postupdate_standard_filemanager($data, 'compactlogo', ['subdirs' => 0], $context,
                                'local_ned_controller', 'compactlogo', $data->id);
                        redirect($url, get_string('ruleupdated', 'local_ned_controller'), 0,
                                \core\output\notification::NOTIFY_SUCCESS);
                    }
                } else if (isset($data->deletebutton)) {
                    //delete rules
                    $DB->delete_records('local_ned_controller_rules', ['id' => $data->id]);
                    redirect($url, get_string('ruleremoved', 'local_ned_controller'), 0, \core\output\notification::NOTIFY_SUCCESS);
                }
            }
            redirect($url);
        }
    }
    $rulestable = '';
    if (!empty($id) && $id > 0) {
        //loading an existing rule into a form
        $rule = $DB->get_record('local_ned_controller_rules', ['id' => $id]);
        //redirect if there is no rule
        if (!$rule) {
            redirect($url);
        }
        $ruleclass->set_rule($rule);
        //load file
        $rule = file_prepare_standard_filemanager($rule, 'logo', ['subdirs' => 0], $context, 'local_ned_controller', 'logo', $id);
        $rule = file_prepare_standard_filemanager($rule, 'compactlogo', ['subdirs' => 0], $context, 'local_ned_controller',
                'compactlogo', $id);
        $mform->set_data($rule);
    } else {
        $ruels = local_ned_controller_get_rules();
        //table formation
        $rulestable = local_ned_controller_table($ruels);
    }
}

echo $OUTPUT->header();

echo $sucessmsg;

if (!empty($id)) {

    $PAGE->requires->strings_for_js(['add_condition',
            'profile_field',
            'courses_category',
            'cancel',
            'user_must_match',
            'of_the_following',
            'or',
            'and',
            'category',
            'user_profile_field',
            'is_equal_to',
            'doesnt_contain',
            'must',
            'must_not',
            'all',
            'any'], 'local_ned_controller');
    $PAGE->requires->yui_module('moodle-local_ned_controller-conditionbowl', 'M.local_ned_controller.conditionbowl.init',
            [$ruleclass->convert_associative_array_for_js(local_ned_controller_get_categoty(), 'field', 'display'),
                    $ruleclass->get_user_field(), $ruleclass->parse_availability()]);
    $mform->display();

} else {

    $output = html_writer::div(get_string('rules_desc', 'local_ned_controller'),'rules-desc');
    //table output
    $output .= html_writer::table($rulestable);
    //link to create a new rule
    $output .= html_writer::link(new moodle_url('', ['id' => -1]), get_string('addrule', 'local_ned_controller'),
            ['class' => 'btn btn-primary']);
    $output .= html_writer::link(new moodle_url(local_ned_controller_get_setting_local_urlpath('ned_controller')), get_string('close', 'local_ned_controller'),
            ['class' => 'btn btn-default btn-secondary rules-button-reset']);

    echo html_writer::div($output,'wrapper-rules');
}

echo $OUTPUT->footer();