<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Plugins overview
 *
 * @package     local_package
 * @category    string
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->libdir . '/formslib.php');


class local_ned_controller_rules_edit_form extends moodleform
{

    protected function definition()
    {
        global $CFG;
        $mform = $this->_form;
        $id = $this->_customdata['id'];
        //Id
        $mform->addElement('hidden', 'id', '');
        $mform->setType('id', PARAM_INT);

        //Name
        $mform->addElement('text', 'name', get_string('name'));
        $mform->addRule('name', get_string('required'), 'required', null, 'client');
        $mform->addRule('name', get_string('maximumchars', '', 255), 'maxlength', 255, 'client');
        $mform->setType('name', PARAM_TEXT);

        //Weight
        $weightopc = [];
        for ($i = -10;$i <= 10;$i++){
            $weightopc[$i]= $i;
        }
        $mform->addElement('select', 'weight', get_string('weight', 'local_ned_controller'), $weightopc);
        $mform->addHelpButton('weight', 'weight', 'local_ned_controller');
        $mform->setDefault('weight', 0);

        //Disabled
        $mform->addElement('advcheckbox', 'disabled', get_string('disabled', 'local_ned_controller'));
        $mform->addHelpButton('disabled', 'disabled', 'local_ned_controller');
        $mform->setDefault('disabled', 0);
        $mform->setType('disabled', PARAM_BOOL);

        //Conditions
        // Availability field. This is just a textarea; the user interface
        // interaction is all implemented in JavaScript. The field is named
        // availabilityconditionsjson for consistency with moodleform_mod.
        $mform->addElement('textarea', 'availabilityconditionsjson',
            get_string('accessrestrictions', 'availability'));

        //Logo
        $mform->addElement('filemanager', 'logo_filemanager', get_string('logo','local_ned_controller'), null, array('accepted_types' => array('.png','.jpg'),'maxfiles' => 1));
        $mform->addHelpButton('logo_filemanager', 'logo', 'local_ned_controller');

        //Compact Logo
        $mform->addElement('filemanager', 'compactlogo_filemanager', get_string('compactlogo','local_ned_controller'), null, array('accepted_types' => array('.png','.jpg'),'maxfiles' => 1));
        $mform->addHelpButton('compactlogo_filemanager', 'compactlogo', 'local_ned_controller');

        //Custom CSS
        $mform->addElement('textarea', 'customcss', get_string("customcss", "local_ned_controller"), 'wrap="virtual" rows="8" cols="500"');
        $mform->addHelpButton('customcss', 'customcss', 'local_ned_controller');

        //Within HEAD
        $mform->addElement('textarea', 'additionalhtmlhead', get_string("additionalhtmlhead", "local_ned_controller"), 'wrap="virtual" rows="8" cols="500"');
        $mform->addHelpButton('additionalhtmlhead', 'additionalhtmlhead', 'local_ned_controller');

        //When BODY is opened
        $mform->addElement('textarea', 'additionalhtmltopofbody', get_string("additionalhtmltopofbody", "local_ned_controller"), 'wrap="virtual" rows="8" cols="500"');
        $mform->addHelpButton('additionalhtmltopofbody', 'additionalhtmltopofbody', 'local_ned_controller');

        //Before BODY is closed
        $mform->addElement('textarea', 'additionalhtmlfooter', get_string("additionalhtmlfooter", "local_ned_controller"), 'wrap="virtual" rows="8" cols="500"');
        $mform->addHelpButton('additionalhtmlfooter', 'additionalhtmlfooter', 'local_ned_controller');

        // Redirect after login
        $mform->addElement('text', 'loggedinredirect', get_string("loggedinredirect", "local_ned_controller"),
            ['size' => 100, 'placeholder' => $CFG->wwwroot]);
        $mform->addHelpButton('loggedinredirect', 'loggedinredirect', 'local_ned_controller');
        $mform->setType('loggedinredirect', PARAM_URL);

        $buttonarray=array();
        $buttonarray[] = $mform->createElement('submit', 'submitbutton', get_string('savechanges'));
        if ($id > 0) {
            $buttonarray[] = $mform->createElement('cancel');
            $buttonarray[] = $mform->createElement('submit', 'deletebutton', get_string('delete'), ['onClick' => 'javascript:return confirm(\'are you sure you want to delete this ? \');']);
        } else {
            $buttonarray[] = $mform->createElement('cancel', null, get_string('close', 'local_ned_controller'));
        }
        $mform->addGroup($buttonarray, 'buttonar', '', ' ', false);
    }
}