YUI.add('moodle-local_ned_controller-conditionbowl', function (Y, NAME) {

M.local_ned_controller = M.local_ned_controller || {};

/**
 * Array with custom fields
 * @type {Array}
 */
M.local_ned_controller.userfields = [];
/**
 * Category Array
 * @type {Array}
 */
M.local_ned_controller.categories = [];
M.local_ned_controller.op = [{field: 'isequalto', display: M.util.get_string('is_equal_to', 'local_ned_controller')},
    {field: 'contains', display: M.util.get_string('doesnt_contain', 'local_ned_controller')}];
M.local_ned_controller.availability_neg = [{field: '', display: M.util.get_string('must', 'local_ned_controller')},
    {field: '!', display: M.util.get_string('must_not', 'local_ned_controller')}];
M.local_ned_controller.availability_op = [{field: '&amp;', display: M.util.get_string('all', 'local_ned_controller')},
    {field: '|', display: M.util.get_string('any', 'local_ned_controller')}];

M.local_ned_controller.conditionbowl = {
    /**
     * Initialization of accessibility rules form
     *
     * @param categories
     * @param userfields
     * @param values
     */
    init: function (categories, userfields, values) {

        M.local_ned_controller.userfields = userfields;
        M.local_ned_controller.categories = categories;

        var panel = new M.core.dialogue({
            modal: true,
            headerContent: M.util.get_string('add_condition', 'local_ned_controller'),
            additionalBaseClass: 'local-ned-controller-modal'
        });
        panel.addButton({
            value: M.util.get_string('profile_field', 'local_ned_controller'),
            section: Y.WidgetStdMod.BODY,
            classNames: 'btn btn-secondary',
            action: function (e) {
                e.preventDefault();
                ravailability.insert(M.local_ned_controller.conditionbowl.get_userfiled(), 'append');
                M.local_ned_controller.conditionbowl.update();
                panel.hide();
            }
        });
        panel.addButton({
            value: M.util.get_string('courses_category', 'local_ned_controller'),
            section: Y.WidgetStdMod.BODY,
            classNames: 'btn btn-secondary',
            action: function (e) {
                e.preventDefault();
                ravailability.insert(M.local_ned_controller.conditionbowl.get_category(), 'append');
                M.local_ned_controller.conditionbowl.update();
                panel.hide();
            }
        });

        panel.addButton({
            value: M.util.get_string('cancel', 'local_ned_controller'),
            classNames: 'btn btn-secondary',
            action: function (e) {
                e.preventDefault();
                panel.hide();
            }
        });
        var availabilityconditionsjson = Y.one('#id_availabilityconditionsjson');

        var obj = Y.Node.create('<div class="wrapper-button">' +
            '<a onclick="return false;" href="#" class="r_add_category btn btn-secondary">' +
            M.util.get_string('add_condition', 'local_ned_controller') + '</a>' +
            '</div>');
        var availabilitynop = M.local_ned_controller.conditionbowl.get_availability_op(values.op);

        var modal = Y.Node.create('<div class="r_availabilityconditions availability-inner">' +
            '<div>' + M.util.get_string('user_must_match', 'local_ned_controller') +
            availabilitynop + M.util.get_string('of_the_following', 'local_ned_controller') +
            '</div><div class="r_availabilitycategoty"></div></div>');
        availabilityconditionsjson.hide();
        availabilityconditionsjson.insert(modal, 'after');

        var divv = Y.one('.r_availabilityconditions');
        var ravailability = Y.one('.r_availabilitycategoty');

        M.local_ned_controller.conditionbowl.load_values(ravailability, values.c);

        divv.insert(obj, 'append');
        divv.delegate('change', function () {
            M.local_ned_controller.conditionbowl.update();
        }, 'select');
        divv.delegate('change', function () {
            M.local_ned_controller.conditionbowl.update();
        }, 'input');
        divv.delegate('click', function () {
            panel.show();
        }, '.r_add_category');
        divv.delegate('click', function (e) {
            var currentTarget = e.currentTarget;
            currentTarget._node.parentElement.remove();
            M.local_ned_controller.conditionbowl.update();
        }, '.r_del');
    },
    /**
     * Form Update Function
     */
    update: function () {
        var availabilityconditionsjson = Y.one('#id_availabilityconditionsjson');
        var value = Y.all('.r_availabilitycategoty .r-field');
        var aop = Y.one('.r_availabilityconditions .availability-op');
        var boxes = Y.all('.r_availabilitycategoty .availability-connector span');

        if (aop.get('value') == '|') {
            boxes.setHTML(M.util.get_string('or', 'local_ned_controller'));
        } else {
            boxes.setHTML(M.util.get_string('and', 'local_ned_controller'));
        }

        var element = {}, params = [];
        var cop, cvalue, ctype, csf;
        value.each(function (node) {
            var name = node.get('name');

            if (name == 'cop') {
                cop = node.get('value');
            }
            if (name == 'csf') {
                csf = node.get('value');
            }
            if (name == 'ctype') {
                ctype = node.get('value');
            }
            if (name == 'cvalue') {
                cvalue = node.get('value');
                element.type = ctype;
                element.op = cop;
                if (csf) {
                    element.sf = csf;
                }
                element.value = cvalue;
                params.push(element);
                element = {};
                csf = '';
            }
        });
        var obj = {'op': aop.get('value'), c: params};
        availabilityconditionsjson.set('value', Y.JSON.stringify(obj));
    },//asf sdf sd f
    /**
     * Getting select with categories
     * @param op
     * @param value
     * @returns {string}
     */
    get_category: function (op, value) {

        var listcategoty = '<select name="cvalue" class="custom-select r-field">';
        var fieldInfo;
        for (var i = 0; i < M.local_ned_controller.categories.length; i++) {
            fieldInfo = M.local_ned_controller.categories[i];
            listcategoty += '<option ';
            if (fieldInfo.field == value) {
                listcategoty += ' selected="selected" ';
            }
            listcategoty += ' value="' + fieldInfo.field + '">' + fieldInfo.display + '</option>';
        }
        listcategoty += '</select>';
        var category = '<div class="r-row"><span class="form-inline availability_course  availability-plugincontrols" >' +
            '<span class="availability-group" >' +
            '<label ><span class="p-r-1" >'+M.util.get_string('category', 'local_ned_controller')+'</span>  ' +
            '<label >' +
            '<input name="ctype" class="r-field" type="hidden" value="category">' +
            M.local_ned_controller.conditionbowl.get_op(op) +
            '</label> ' + listcategoty +
            '</label></span></span><span class="r_del p-x-1 btn btn-secondary">X</span>' +
            '<div class="availability-connector" ><span class="label" >' +
            M.util.get_string('and', 'local_ned_controller') + '</span></div>' +
            '</div>';

        return category;
    },
    /**
     * Getting select with user fields
     * @param sf
     * @param op
     * @param value
     * @returns {string}
     */
    get_userfiled: function (sf, op, value) {

        var ccsf = '<select name="csf" class="custom-select r-field">';
        var fieldInfo;

        for (var i = 0; i < M.local_ned_controller.userfields.length; i++) {
            fieldInfo = M.local_ned_controller.userfields[i];
            ccsf += '<option ';
            if (fieldInfo.field == sf) {
                ccsf += ' selected="selected" ';
            }
            ccsf += ' value="' + fieldInfo.field + '">' + fieldInfo.display + '</option>';
        }
        ccsf += '</select>';
        if (!value) {
            value = '';
        }
        var userprofile = '<div class="r-row"><span class="form-inline availability_course  availability-plugincontrols" >' +
            '<span class="availability-group" >' +
            '<span class="p-r-1" >' + M.util.get_string('user_profile_field', 'local_ned_controller') + '</span>  ' +
            ccsf +
            '<input name="ctype" class="r-field" type="hidden" value="userprofile">' +
            M.local_ned_controller.conditionbowl.get_op(op) +
            '</label> ' +
            '<input name="cvalue" class="r-field form-control" type="text" value="' + value + '">' +
            '</label></span></span><span class="r_del p-x-1 btn btn-secondary">X</span>' +
            '<div class="availability-connector" ><span class="label" >' +
            M.util.get_string('and', 'local_ned_controller') + '</span></div>' +
            '</div>';

        return userprofile;
    },
    get_op: function (op) {
        var ccsf = '<select name="cop" title="Method of comparison" class="custom-select r-field" >';
        var fieldInfo;

        for (var i = 0; i < M.local_ned_controller.op.length; i++) {
            fieldInfo = M.local_ned_controller.op[i];
            ccsf += '<option ';
            if (fieldInfo.field == op) {
                ccsf += ' selected="selected" ';
            }
            ccsf += ' value="' + fieldInfo.field + '">' + fieldInfo.display + '</option>';
        }
        ccsf += '</select>';
        return ccsf;
    },
    get_availability_neg: function (value) {
        var ccsf = '<select class="availability-neg custom-select" title="Restriction type">';
        var fieldInfo;
        var must = '';
        if (value.indexOf("!") !== -1) {
            must = '!';
        }
        for (var i = 0; i < M.local_ned_controller.availability_neg.length; i++) {
            fieldInfo = M.local_ned_controller.availability_neg[i];
            ccsf += '<option ';
            if (fieldInfo.field == must) {
                ccsf += ' selected="selected" ';
            }
            ccsf += ' value="' + fieldInfo.field + '">' + fieldInfo.display + '</option>';
        }
        ccsf += '</select>';
        return ccsf;
    },
    get_availability_op: function (value) {
        var ccsf = '<select class="availability-op custom-select" title="Required restrictions" >';
        var fieldInfo;
        var must = '&';
        if (value.indexOf("|") !== -1) {
            must = '|';
        }

        for (var i = 0; i < M.local_ned_controller.availability_op.length; i++) {
            fieldInfo = M.local_ned_controller.availability_op[i];
            ccsf += '<option ';
            if (fieldInfo.field == must) {
                ccsf += ' selected="selected" ';
            }
            ccsf += ' value="' + fieldInfo.field + '">' + fieldInfo.display + '</option>';
        }
        ccsf += '</select>';
        return ccsf;
    },
    /**
     * Loading values into the form
     * @param ravailability
     * @param values
     */
    load_values: function (ravailability, values) {
        var fieldInfo;
        for (var i = 0; i < values.length; i++) {
            fieldInfo = values[i];
            if (fieldInfo.type == 'category') {
                ravailability.insert(M.local_ned_controller.conditionbowl.get_category(fieldInfo.op, fieldInfo.value), 'append');
            }
            if (fieldInfo.type == 'userprofile') {
                ravailability.insert(
                    M.local_ned_controller.conditionbowl.get_userfiled(fieldInfo.sf, fieldInfo.op, fieldInfo.value), 'append');
            }
        }
        var aop = Y.one('.r_availabilityconditions .availability-op');
        var boxes = Y.all('.r_availabilitycategoty .availability-connector span');

        if (aop.get('value') == '|') {
            boxes.setHTML('or');
        } else {
            boxes.setHTML('and');
        }
    }
};

}, '@VERSION@', {
    "requires": [
        "base",
        "node",
        "event",
        "event-delegate",
        "panel",
        "moodle-core-notification-dialogue",
        "json"
    ]
});
