<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Infraction Form
 *
 * @package    local_proxy
 * @copyright  2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_proxy\form;

defined('MOODLE_INTERNAL') || die();
/** @var object $CFG */
require_once($CFG->libdir . '/formslib.php');
require_once($CFG->dirroot . '/mod/assign/submission/proxy/locallib.php');

/**
 * Class infraction
 * @package local_proxy\form
 */
class submission extends \moodleform {

    public function definition(){
        $mform = $this->_form;
        $customdate = $this->_customdata;
        $assign = $customdate['assign'];
        $submission = $customdate['submission'];
        $user = $customdate['user'];
        /** @var \assign_submission_proxy $assignsubmissionproxy */
        $assignsubmissionproxy = $customdate['assignsubmissionproxy'];

        $fileoptions = $this->get_file_options($assignsubmissionproxy);

        $mform->addElement('filemanager', 'files_filemanager', $assignsubmissionproxy->get_name(), null, $fileoptions);

        if ($submission){
            $mform->addElement('hidden', 'lastmodified', $submission->timemodified);
            $mform->setType('lastmodified', PARAM_INT);
        }

        $mform->addElement('hidden', 'id', $submission->timemodified ?? 0);
        $mform->setType('id', PARAM_INT);

        $mform->addElement('hidden', 'userid', $submission->timemodified ?? 0);
        $mform->setType('userid', PARAM_INT);

        $mform->addElement('hidden', 'groupid', $submission->timemodified ?? 0);
        $mform->setType('groupid', PARAM_INT);

        $this->add_action_buttons(true);
    }

    /**
     * @param array $data
     * @param array $files
     * @return array
     */
    public function validation($data, $files){
        $errors = array();
        return $errors;
    }

    /**
     * File format options
     *
     * @return array
     */
    public function get_file_options($assignsubmissionproxy){
        $fileoptions = array(
            'subdirs' => 1,
            'maxbytes' => $assignsubmissionproxy->get_config('maxsubmissionsizebytes'),
            'maxfiles' => $assignsubmissionproxy->get_config('maxfilesubmissions'),
            'accepted_types' => $this->get_configured_typesets($assignsubmissionproxy),
            'return_types' => (FILE_INTERNAL | FILE_CONTROLLED_LINK));
        if ($fileoptions['maxbytes'] == 0){
            // Use module default.
            $fileoptions['maxbytes'] = get_config('assignsubmission_proxy', 'maxbytes');
        }
        return $fileoptions;
    }

    /**
     * Get the type sets configured for this assignment.
     *
     * @return array('groupname', 'mime/type', ...)
     */
    private function get_configured_typesets($assignsubmissionproxy){
        $typeslist = (string)$assignsubmissionproxy->get_config('filetypeslist');

        $util = new \core_form\filetypes_util();
        $sets = $util->normalize_file_types($typeslist);

        return $sets;
    }
}
