<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Library
 *
 * @package   local_proxy
 * @copyright 2021 Michael Gardener <mgardener@cissq.com>
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once("$CFG->dirroot/mod/assign/locallib.php");

/**
 * Adds module specific settings to the settings block
 *
 * @param settings_navigation $settings The settings navigation object
 * @param $context Context
 */
function local_proxy_extend_settings_navigation(settings_navigation $settings, $context){
    global $PAGE;

    if ($context->contextlevel !== CONTEXT_MODULE){
        return;
    }

    if ($PAGE->cm->modname <> 'assign'){
        return;
    }

    if (!has_any_capability(['assignsubmission/proxy:submit', 'assignsubmission/proxy:manage'], $context)){
        return;
    }

    $assign = new assign($context, null, null);

    /** @var assign_submission_proxy $assignsubmissionproxy */
    if (!$assignsubmissionproxy  = $assign->get_submission_plugin_by_type('proxy')){
        return;
    }
    $cfg = $assignsubmissionproxy->get_config();
    if (empty($cfg->enabled)){
        return;
    }

    if ($settingnode = $settings->find('modulesettings', navigation_node::TYPE_SETTING)){
        $keys = $settingnode->get_children_key_list();
        $beforekey = null;
        $i = array_search('mod_assign_useroverrides', $keys);
        if ($i === false && array_key_exists(0, $keys)){
            $beforekey = $keys[0];
        } elseif (array_key_exists($i + 1, $keys)){
            $beforekey = $keys[$i + 1];
        }

        if (has_capability('assignsubmission/proxy:submit', $context)){
            $node = navigation_node::create(get_string('proxysubmission', 'local_proxy'),
                new moodle_url('/local/proxy/submission.php', array('id' => $PAGE->cm->id)),
                navigation_node::TYPE_SETTING, null, 'local_proxy_submission',
                new pix_icon('i/upload', ''));
            $settingnode->add_node($node, $beforekey);
        }

        if (has_capability('assignsubmission/proxy:manage', $context)){
            $node = navigation_node::create(get_string('proxyoverview', 'local_proxy'),
                new moodle_url('/local/proxy/overview.php', array('id' => $PAGE->course->id)),
                navigation_node::TYPE_SETTING, null, 'local_proxy_overview',
                new pix_icon('i/folder', ''));
            $settingnode->add_node($node, $beforekey);
        }

        // Remove Download all submissions link
        if (!has_capability('mod/assign:grade', $context)){
            /** @var navigation_node $child */
            foreach ($settingnode->children as $child){
                if ($child->text == get_string('downloadall', 'assign')){
                    $child->display = false;
                }
            }
        }
    }
}