<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Observer.
 *
 * @package     local_tem
 * @category    classes
 * @copyright   2023 Michael Gardener <mgardener@cissq.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_tem;

defined('MOODLE_INTERNAL') || die();

/**
 * Event observers.
 */
class observer {

    /**
     * Event processor - attempt_started added.
     * @param \mod_quiz\event\attempt_started $event
     */
    public static function attempt_started(\mod_quiz\event\attempt_started $event) {
        global $DB;

        $cfg = get_config('local_tem');

        if (!$cfg->enable) {
            return;
        }

        $attempt = $DB->get_record('quiz_attempts', ['id' => $event->objectid]);
        helper::process_attempt_session($attempt);
    }

    /**
     * User loggedin event observer.
     *
     * @param \core\event\user_loggedin $event The event.
     */
    public static function user_loggedin(\core\event\user_loggedin $event) {
        $cfg = get_config('local_tem');

        if (!$cfg->enable) {
            return;
        }

        if (is_siteadmin() || !helper::can_view_sessions()) {
            return;
        }

        $eventdata = $event->get_data();

        helper::tem_submission_notify_or_redirect($eventdata['userid'], true);
    }

    /**
     * User loggedin event observer.
     *
     * @param \core\event\user_loggedinas $event The event.
     */
    public static function user_loggedinas(\core\event\user_loggedinas $event) {
        $cfg = get_config('local_tem');

        if (!$cfg->enable) {
            return;
        }

        if (!helper::can_view_sessions()) {
            return;
        }

        helper::tem_submission_notify_or_redirect($event->relateduserid, true);
    }
}
