<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * report_header
 *
 * @package    local_proxy
 * @copyright  2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_tem\output;


use local_tem\helper;
use local_tem\report;

defined('MOODLE_INTERNAL') || die();

/**
 * Class proxy_overview
 * @package local_proxy\output
 */
class report_attempts implements \renderable, \templatable {
    /**
     * @var report
     */
    private $report;


    public function __construct(report $report) {
        $this->report = $report;
    }

    /**
     * Export page contents for template
     * @param \renderer_base $output
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output){
        $data = new \stdClass();
        $data->columns = [
            get_string('student', 'local_tem'),
            get_string('start', 'local_tem'),
            get_string('end', 'local_tem'),
            get_string('duration', 'local_tem'),
            get_string('ipaddress', 'local_tem'),
        ];

        $data->rows = [];

        list($allusers, $availableusers, $completed) = helper::get_session_users(
            $this->report->quiz->id,
            $this->report->course->id,
            $this->report->group->id,
            $this->report->session->sessionnum
        );
        $unattempted = array_diff($availableusers, $completed);

        if ($completed && $attempts = $this->report->get_attempts()) {
            foreach ($attempts as $key => $attempt) {
                if (in_array($attempt->userid, $completed)) {
                    if ($attempt->timefinish) {
                        $duration = format_time($attempt->timefinish - $attempt->timestart);
                    } else {
                        $duration = '-';
                    }
                    $row = [
                        'student' => "{$attempt->firstname} {$attempt->lastname}",
                        'start' => ($attempt->timestart) ? date('m/d/Y H:i:s', $attempt->timestart) : '',
                        'end' => ($attempt->timefinish) ? date('m/d/Y H:i:s', $attempt->timefinish) : '',
                        'duration' => $duration,
                        'ipaddress' => $attempt->ip,
                    ];
                    $data->rows[] = $row;
                }
            }
        }

        if ($unattempted) {
            foreach ($unattempted as $userid) {
                if ($user = \core_user::get_user($userid)) {
                    $row = [
                        'rowclass' => "bg-grey",
                        'student' => "{$user->firstname} {$user->lastname}",
                        'start' => '?',
                        'end' => '',
                        'duration' => '',
                        'ipaddress' => '',
                    ];
                    $data->rows[] = $row;
                }
            }
        }

        return $data;
    }
}
