<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Assign default proctor
 *
 * @package    local_tem
 * @copyright  2024 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_tem\task;

use Exception;
use local_schoolmanager\school_manager as SM;
use local_tem\helper;
use local_tem\shared_lib as NED;


defined('MOODLE_INTERNAL') || die();

class assign_default_proctor extends \core\task\scheduled_task {

    public function get_name() {
        return get_string('assigndefaultproctor', 'local_tem');
    }

    public function execute() {
        global $DB;

        cron_setup_user();

        $sql = 'SELECT s.id, s.schoolid, p.proctor
                  FROM {local_tem_session} s
	              JOIN {local_tem_report} r ON  s.id = r.sessionid
	         LEFT JOIN {local_tem_proctor} p ON  s.id = p.sessionid
                 WHERE p.proctor IS NULL OR p.proctor = 0';

        $SM = SM::get_school_manager();

        if ($sessions = $DB->get_records_sql($sql)) {
            foreach ($sessions as $session) {
                if ($administrator = $SM->get_school_students($session->schoolid, true, $SM::SCHOOL_ADMINISTRATOR_ROLE, false)) {
                    $administrator = reset($administrator);
                    helper::assign_proctor($session->id, $administrator->id);
                    mtrace("Default proctor ({$administrator->id}) is assigned to session ({$session->id}) in school ({$session->schoolid})");
                }
            }
        }
    }
}