<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Initialize sessions.
 *
 * @package     local_tem
 * @category    classes
 * @copyright   2023 Michael Gardener <mgardener@cissq.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools\deadline_manager;
use local_tem\helper;

define('CLI_SCRIPT', true);

require(__DIR__ . '/../../../config.php');
require_once($CFG->libdir . '/clilib.php');
require_once($CFG->dirroot . '/mod/quiz/attemptlib.php');

// Get the cli options.
list($options, $unrecognized) = cli_get_params(['help' => false], ['h' => 'help']);

$help =
    "
Help message for local_tem cli script.

Please include a list of options and associated actions.

Please include an example of usage.
";

if ($unrecognized) {
    $unrecognized = implode("\n\t", $unrecognized);
    cli_error(get_string('cliunknownoption', 'local_tem', $unrecognized));
}

if ($options['help']) {
    cli_writeln($help);
    die();
}

echo html_to_text(get_string('importsure', 'local_tem'))."\n\n";
$prompt = get_string('cliyesnoprompt', 'local_tem');
$input = cli_input($prompt, '', array(get_string('clianswerno', 'admin'), get_string('cliansweryes', 'admin')));
if ($input == get_string('clianswerno', 'admin')) {
    exit(1);
}
cli_separator();
echo html_to_text('It has been started')."\n";
echo html_to_text("++++++++++++++++++++++++")."\n";

$cfg = get_config('local_tem');
$startdate = strtotime(get_config('local_tem', 'startdate'));
$startdate = time() - YEARSECS;

$sql = "SELECT qa.id, 
               qa.quiz, 
               qa.userid, 
               qa.attempt, 
               qa.state, 
               qa.timestart, 
               qa.timefinish, 
               q.course, 
               g.id AS groupid, 
               g.schedule, 
               g.startdate, 
               g.enddate,
               (SELECT l.ip FROM {logstore_standard_log} l
                 WHERE l.eventname = '\\mod_quiz\\event\\attempt_started' 
                 AND l.objectid = qa.id 
                 AND l.component = 'mod_quiz'
                 AND l.objecttable = 'quiz_attempts' LIMIT 1) ip
          FROM {quiz_attempts} qa
	      JOIN {quiz} q ON qa.quiz = q.id
	      JOIN {groups_members} gm ON qa.userid = gm.userid
	      JOIN {groups} g ON gm.groupid = g.id AND q.course = g.courseid
         WHERE qa.state IN (?, ?) AND q.timeopen > ? AND g.schedule = ? 
      ORDER BY qa.timestart ASC";
$sql = "SELECT qa.id, 
               qa.quiz, 
               qa.userid, 
               qa.attempt, 
               qa.state, 
               qa.timestart, 
               qa.timefinish, 
               q.course, 
               g.id AS groupid, 
               g.schedule, 
               g.startdate, 
               g.enddate,
               '' ip
          FROM {quiz_attempts} qa
	      JOIN {quiz} q ON qa.quiz = q.id
	      JOIN {groups_members} gm ON qa.userid = gm.userid
	      JOIN {groups} g ON gm.groupid = g.id AND q.course = g.courseid
         WHERE qa.state IN (?, ?) AND q.timeopen > ? AND g.schedule = ? 
      ORDER BY qa.timestart ASC";

$rs = $DB->get_recordset_sql($sql, [
    \quiz_attempt::FINISHED,
    \quiz_attempt::IN_PROGRESS,
    $startdate,
    deadline_manager::SCHEDULE_FULL
]);

foreach ($rs as $attempt) {
    helper::process_attempt_session($attempt);
}

$rs->close();

echo html_to_text("++++++++++++++++++++++++")."\n";
echo html_to_text("Ended")."\n";
