<?php
/**
 * @package    local_tem
 * @subpackage NED
 * @copyright  2024 NED {@link http://ned.ca}
 * @author     NED {@link http://ned.ca}
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use block_ned_teacher_tools\deadline_manager as DM;
use local_tem\shared_lib as NED;
use local_tem\helper;

/**
 * All upgrades checks from Moodle 3
 *
 * @param int $oldversion
 */
function local_tem_moodle3_upgrades($oldversion): void{
    global $DB;
    $dbman = $DB->get_manager();

    if ($oldversion < 2023090101) {

        // Define field signature to be added to local_tem_report.
        $table = new xmldb_table('local_tem_report');
        $field = new xmldb_field('signature', XMLDB_TYPE_TEXT, null, null, null, null, null, 'resolutionnote');

        // Conditionally launch add field signature.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        // Tem savepoint reached.
        upgrade_plugin_savepoint(true, 2023090101, 'local', 'tem');
    }

    if ($oldversion < 2023091000) {
        $DB->execute("UPDATE {local_tem_session} SET sessionnum = NULL");

        // Changing type of field sessionnum on table local_tem_session to int.
        $table = new xmldb_table('local_tem_session');
        $field = new xmldb_field('sessionnum', XMLDB_TYPE_INTEGER, '10', null, null, null, null, 'quizid');

        // Launch change of type for field sessionnum.
        $dbman->change_field_type($table, $field);


        // Define field totalsessionnum to be added to local_tem_session.
        $table = new xmldb_table('local_tem_session');
        $field = new xmldb_field('totalsessionnum', XMLDB_TYPE_INTEGER, '10', null, null, null, null, 'sessionnum');

        // Conditionally launch add field totalsessionnum.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $sql = "SELECT s.courseid, s.groupid, s.quizid FROM {local_tem_session} s GROUP BY s.courseid, s.groupid, s.quizid";

        $rs = $DB->get_recordset_sql($sql);
        foreach ($rs as $rec) {
            helper::build_session_number($rec->courseid, $rec->quizid, $rec->groupid );
        }
        $rs->close();

        // Tem savepoint reached.
        upgrade_plugin_savepoint(true, 2023091000, 'local', 'tem');
    }

    if ($oldversion < 2023100500) {

        // Define field schoolid to be added to local_tem_session.
        $table = new xmldb_table('local_tem_session');
        $field = new xmldb_field('schoolid', XMLDB_TYPE_INTEGER, '10', null, null, null, null, 'id');

        // Conditionally launch add field schoolid.
        if (!$dbman->field_exists($table, $field)) {
            $dbman->add_field($table, $field);
        }

        $rs = $DB->get_recordset('local_tem_session');
        foreach ($rs as $rec) {
            if ($cohort = DM::get_school_cohort($rec->groupid)) {
                $schoolid = $cohort->id;
            } else {
                $schoolid = 0;
            }
            $DB->set_field('local_tem_session', 'schoolid', $schoolid, ['id' => $rec->id]);
        }
        $rs->close();

        // Tem savepoint reached.
        upgrade_plugin_savepoint(true, 2023100500, 'local', 'tem');
    }
}
