<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin strings are defined here.
 *
 * @package     local_tem
 * @category    string
 * @copyright   2023 Michael Gardener <mgardener@cissq.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['actionrequired'] = 'Action Required';
$string['class'] = 'Class';
$string['classname'] = 'Class name';
$string['clickheretosign'] = 'Click here to sign';
$string['cliunknownoption'] = 'Unknowm option {$a}';
$string['cliyesnoprompt'] = 'type y (means yes) or n (means no)';
$string['completed'] = 'Completed';
$string['course'] = 'Course';
$string['coursename'] = 'Course name';
$string['dateofattempt'] = 'Date of Attempt';
$string['differentipreason'] = 'Please explain why the IP addresses are not the same for all students during this class';
$string['duration'] = 'Duration';
$string['enableplugin'] = 'Enable Test & Exam Monitor';
$string['end'] = 'End';
$string['endtime'] = 'End time';
$string['export'] = 'Export';
$string['flagresolution'] = 'Flag resolution';
$string['followup'] = 'Follow-up required';
$string['hidedisabledschools'] = 'Hide schools with disabled TEM';
$string['high'] = 'High';
$string['importsure'] = 'Would you like to run script?';
$string['ipaddress'] = 'IP Address';
$string['irregulareventviolation'] = 'Were there any irregular events or academic integrity violations during this test or exam?';
$string['irregulareventviolationreason'] = 'Please provide details about the irregular events or academic integrity violations that occurred during this test. Upload all screenshots and photo evidence pertaining to the irregular event/academic integrity violation.';
$string['lastthirtydays'] = 'Last 30 days';
$string['linktovideorecording'] = 'Link to video recording';
$string['low'] = 'Low';
$string['missed'] = 'Missed';
$string['nextthirtydays'] = 'Next 30 days';
$string['noattemptreason'] = 'The table above shows that one or more students in this class did not complete this test or exam. Please provide a reason for each of these students.';
$string['numberofproctors'] = 'Number of total proctors (including myself) proctoring this test session';
$string['open'] = 'Open';
$string['openvideo'] = 'Open video';
$string['pluginname'] = 'Test & Exam Monitor';
$string['proctor'] = 'Proctor';
$string['proctorbadge'] = 'Proctor badge';
$string['quiz'] = 'Quiz';
$string['report'] = 'Report';
$string['resolutionnote'] = 'Resolution Note';
$string['resolutionseverity'] = 'Resolution Severity';
$string['resolutionstatus'] = 'Resolution Status';
$string['resolved'] = 'Resolved';
$string['sameroom'] = 'Did all students complete this test/exam in the same room?';
$string['sameroomreason'] = 'Please provide a valid reason for why students did not complete this test in the same room';
$string['scheduled'] = 'Scheduled';
$string['session'] = 'Session';
$string['sessioninprogress'] = 'Session in progress...';
$string['sessionnum'] = 'Session';
$string['showall'] = 'Show all';
$string['showdisabledschools'] = 'Show schools with disabled TEM';
$string['signaturetext'] = 'Signed by {$a->name} on {$a->date}.';
$string['start'] = 'Start';
$string['startdate'] = 'Start date';
$string['starttime'] = 'Start time';
$string['student'] = 'Student';
$string['submit'] = 'Submit';
$string['tem:manageallsessions'] = 'TEM - Manage sessions for all schools (Rosedale staff)';
$string['tem:manageflaggedsessions'] = 'TEM - Can manage flagged sessions';
$string['tem:manageownsessions'] = 'TEM - Manager sessions for own school (Proctor Manager)';
$string['tem:viewallsessions'] = 'TEM - View sessions for all schools (Rosedale staff)';
$string['tem:viewappointedsessions'] = 'TEM - Proctor role for appointed sessions (Proctor)';
$string['tem:viewownclasssessions'] = 'TEM - View sessions for own classes (Classroom Teacher)';
$string['tem:viewownsessions'] = 'TEM - View sessions for own school (Observer for school)';
$string['testsexams'] = 'Tests & Exams';
$string['textexam'] = 'Test/Exam';
$string['unknown'] = 'Unknown';
$string['video'] = 'Video';
$string['view'] = 'View';
$string['temredirectmsg'] = 'One or more Proctor Reports for this class is more than 24 hours overdue. You will be redirected to the TEM page now.';
$string['assigndefaultproctor'] = 'Assign default proctor';
$string['school'] = 'School';
$string['proctormanager'] = 'Proctor manager';
