<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Infraction Delete
 *
 * @package    local_tem
 * @copyright  2023 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

use local_tem\shared_lib as NED;
use local_tem\helper;

require_once(dirname(__FILE__, 3) . '/config.php');

$id        = optional_param(NED::PAR_ID, 0, PARAM_INT);
$returnurl = optional_param(NED::PAR_RETURN_URL, '', PARAM_LOCALURL);
$process   = optional_param('process', 0, PARAM_INT);

require_login(null, false);
$contextsystem = context_system::instance();

$session = \local_tem\helper::get_session($id);

// Permission.
if (!$session || !helper::can_delete_session($session)) {
    throw new moodle_exception('permission');
}

$pageparams = [NED::PAR_ID => $id, NED::PAR_RETURN_URL => $returnurl];
$thispageurl = new moodle_url('/local/tem/session_delete.php', $pageparams);

$PAGE->set_url($thispageurl);
$PAGE->set_pagelayout('base');
$PAGE->set_context($contextsystem);
$PAGE->add_body_classes(['path-report-ghs', 'path-blocks-ned_teacher_tools']);

$name = get_string('pluginname', 'local_tem');
$title = get_string('pluginname', 'local_tem');
$heading = $SITE->fullname;

if ($returnurl) {
    $redirecturl = new \moodle_url($returnurl);
} else {
    $redirecturl = new moodle_url('/local/tem/sessions.php');
}

if ($process){
    $DB->delete_records('local_tem_session', ['id' => $session->id]);
    $DB->delete_records('local_tem_report', ['sessionid' => $session->id]);
    $DB->delete_records('local_tem_proctor', ['sessionid' => $session->id]);
    $DB->delete_records('local_tem_attempt', ['sessionid' => $session->id]);
    helper::build_session_number($session->courseid, $session->quizid, $session->groupid);
    redirect($redirecturl);
    die;
}

echo $OUTPUT->header();

$continue = clone $thispageurl;
$continue->param('process', 1);

$data = (object)[
    'course' => $session->course,
    'class' => $session->class,
    'quiz' => $session->quiz,
    'sessionnum' => $session->sessionnum,
];

$message = $OUTPUT->render_from_template('local_tem/session_delete_confirm', $data);

echo $OUTPUT->confirm($message, $continue, $redirecturl);

echo $OUTPUT->footer();
