<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Plugin administration pages are defined here.
 *
 * @package     local_tem
 * @category    admin
 * @copyright   2023 Michael Gardener <mgardener@cissq.com>
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

global $ADMIN;
if ($hassiteconfig) {

    $settings = new admin_settingpage('local_tem', get_string('pluginname', 'local_tem'));

    $settings->add(
        new admin_setting_configcheckbox(
            'local_tem/enable',
            get_string('enableplugin', 'local_tem'),
            '',
            0
        )
    );

    if ($badges = $DB->get_records('badge', array('type' => 1))) {
        $badgeslist = array();
        foreach ($badges as $badge) {
            if ($badge->status == 1 || $badge->status == 3) {
                $badgeslist[$badge->id] = $badge->name;
            }
        }

        $settings->add(
            new admin_setting_configselect(
                'local_tem/proctorbadge',
                get_string('proctorbadge', 'local_tem'),
                '',
                0,
                $badgeslist
            )
        );
    }

    $settings->add(
        new admin_setting_configtext(
            'local_tem/startdate',
            get_string('startdate', 'local_tem'),
            'YYYY-MM-DD',
            '2023-09-01'
        )
    );

    $ADMIN->add('localplugins', $settings);
}
