<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Filter
 *
 * @package    local_worksheet
 * @copyright  2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_worksheet\output;

defined('MOODLE_INTERNAL') || die();

use \local_worksheet\helper;
use stdClass;

/**
 * Class filter
 * @package local_worksheet\output
 */
class filter implements \renderable, \templatable {
    /**
     * @var int
     */
    protected $courseid;
    /**
     * @var int
     */
    protected $quizid;
    /**
     * @var bool
     */
    protected $showquestions;
    /**
     * @var string
     */
    protected $search;

    /**
     * filter constructor.
     * @param int $courseid
     * @param int $quizid
     */
    public function __construct(int $courseid, int $quizid, bool $showquestions, string $search) {
        $this->courseid = $courseid;
        $this->quizid = $quizid;
        $this->showquestions = $showquestions;
        $this->search = $search;
    }

    /**
     * Export page contents for template
     * @param \renderer_base $output
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output) {

        $data = new stdClass();
        $data->showquestions = $this->showquestions;
        $data->search = $this->search;

        $courses = helper::get_courses();

        if (isset($courses[$this->courseid])) {
            $courses[$this->courseid]->selected = true;
        }

        foreach ($courses as $index => $course) {
            if (!$quizzes = helper::get_quizzes($course->id)) {
                unset($courses[$index]);
            }
            if ($this->courseid == $course->id) {
                if (isset($quizzes[$this->quizid])) {
                    $quizzes[$this->quizid]->selected = true;
                }
                $data->quizzes = array_values($quizzes);
            }
        }
        $data->hasquiz = !empty($data->quizzes);

        $data->hascourse = !empty($courses);
        $data->courses = array_values($courses);
        if (!empty($this->quizid)) {
            if ($cm = get_coursemodule_from_instance('quiz', $this->quizid)) {
                $data->quizlink = (new \moodle_url('/mod/quiz/view.php', ['id' => $cm->id]))->out();
            }
        }

        return $data;
    }
}

