<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Filter
 *
 * @package    local_worksheet
 * @copyright  2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_worksheet\output;

defined('MOODLE_INTERNAL') || die();

use \local_worksheet\helper;
use stdClass;

/**
 * Class graderinfo
 * @package local_worksheet\output
 */
class graderinfo implements \renderable, \templatable {
    /**
     * @var int
     */
    protected $quizid;
    /**
     * @var bool
     */
    protected $showquestions;
    /**
     * @var string
     */
    protected $search;

    /**
     * graderinfo constructor.
     * @param int $quizid
     */
    public function __construct(int $quizid, bool $showquestions, string $search) {
        $this->quizid = $quizid;
        $this->showquestions = $showquestions;
        $this->search = $search;
    }

    /**
     * Export page contents for template
     * @param \renderer_base $output
     * @return \stdClass
     */
    public function export_for_template(\renderer_base $output) {
        $data = new stdClass();

        $questions = helper::get_worksheet_questions($this->quizid,  $this->search);

        $data->hasquestion = !empty($questions);
        if ($questions) {
            $data->questions = array_values($questions);
        }
        $data->showquestions = $this->showquestions;

        return $data;
    }
}