<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Contains class local_worksheet\output\renderer
 *
 * @package    local_worksheet
 * @copyright  2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace local_worksheet\output;

defined('MOODLE_INTERNAL') || die();

class renderer extends \plugin_renderer_base {
    /**
     * @param filter $filter
     * @return bool|string
     * @throws \moodle_exception
     */
    public function render_filter(filter $filter) {
        $data = $filter->export_for_template($this);
        return $this->render_from_template('local_worksheet/filter', $data);
    }

    /**
     * @param graderinfo $graderinfo
     * @return bool|string
     * @throws \moodle_exception
     */
    public function render_graderinfo(graderinfo $graderinfo) {
        $data = $graderinfo->export_for_template($this);
        return $this->render_from_template('local_worksheet/graderinfo', $data);
    }
}
