<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Submission Form
 *
 * @package    assignsubmission_ctsubmission
 * @copyright  2021 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace assignsubmission_ctsubmission\form;

defined('MOODLE_INTERNAL') || die();

use assign_submission_ctsubmission;

/** @var object $CFG */
require_once($CFG->libdir . '/formslib.php');
require_once($CFG->dirroot . '/mod/assign/submission/ctsubmission/locallib.php');

/**
 * Class infraction
 * @package assignsubmission_ctsubmission\form
 */
class submission extends \moodleform {

    public function definition() {
        $mform = $this->_form;
        $customdata = $this->_customdata;
        $assign = $customdata['assign'];
        $submission = $customdata['submission'];
        /** @var assign_submission_ctsubmission $assignsubmissionctsubmission */
        $assignsubmissionctsubmission = $customdata['assignsubmissionct'];

        $fileoptions = $this->get_file_options($assignsubmissionctsubmission);

        $mform->addElement('filemanager', 'files_filemanager', $assignsubmissionctsubmission->get_name(), null, $fileoptions);

        $mform->addElement('hidden', 'id', $submission->timemodified ?? 0);
        $mform->setType('id', PARAM_INT);

        $mform->addElement('hidden', 'userid', $submission->timemodified ?? 0);
        $mform->setType('userid', PARAM_INT);

        $mform->addElement('hidden', 'groupid', $submission->timemodified ?? 0);
        $mform->setType('groupid', PARAM_INT);

        $this->add_action_buttons(true);
    }

    /**
     * @param array $data
     * @param array $files
     * @return array
     */
    public function validation($data, $files) {
        $errors = array();
        return $errors;
    }

    /**
     * File format options
     *
     * @return array
     */
    public function get_file_options($assignsubmissionctsubmission) {
        $fileoptions = array(
            'subdirs' => 1,
            'maxbytes' => $assignsubmissionctsubmission->get_config('maxsubmissionsizebytes'),
            'maxfiles' => $assignsubmissionctsubmission->get_config('maxfilesubmissions'),
            'accepted_types' => $this->get_configured_typesets($assignsubmissionctsubmission),
            'return_types' => (FILE_INTERNAL | FILE_CONTROLLED_LINK));
        if ($fileoptions['maxbytes'] == 0) {
            // Use module default.
            $fileoptions['maxbytes'] = get_config('assignsubmission_ctsubmission', 'maxbytes');
        }
        return $fileoptions;
    }

    /**
     * Get the type sets configured for this assignment.
     *
     * @return array('groupname', 'mime/type', ...)
     */
    private function get_configured_typesets($assignsubmissionctsubmission) {
        $typeslist = (string)$assignsubmissionctsubmission->get_config('filetypeslist');

        $util = new \core_form\filetypes_util();
        $sets = $util->normalize_file_types($typeslist);

        return $sets;
    }
}
