<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Helper
 *
 * @package    assignsubmission_ctsubmission
 * @copyright  2020 Michael Gardener <mgardener@cissq.com>
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

namespace assignsubmission_ctsubmission;

use assignsubmission_ctsubmission\shared_lib as NED;

defined('MOODLE_INTERNAL') || die();

/** @var object $CFG */
require_once($CFG->dirroot . '/mod/assign/locallib.php');

/**
 * Class helper
 * @package assignsubmission_ctsubmission
 */
class helper {
    /**
     * @param array $cap
     * @param numeric $courseid
     *
     * @return array|null
     */
    public static function get_courses($cap=[], $courseid=0){
        global $DB;

        if (empty($cap)){
            $cap = ['assignsubmission/ctsubmission:submit', 'assignsubmission/ctsubmission:approve'];
        }

        if (is_siteadmin()){
            if ($courseid){
                $course = NED::get_course($courseid);
                if (!$course) return [];

                $enrolledcourses = [$course->id => $course];
            } else {
                $enrolledcourses = NED::get_all_courses();
            }
        } else {
            $enrolledcourses = enrol_get_my_courses(['id'], null, 0, $courseid ? [$courseid] : []);
            foreach ($enrolledcourses as $index => $enrolledcourse){
                if (!has_any_capability($cap, NED::ctx($enrolledcourse->id))){
                    unset($enrolledcourses[$index]);
                }
            }
        }

        if (!$enrolledcourses){
            return null;
        }

        list($insql, $params) = $DB->get_in_or_equal(array_keys($enrolledcourses));

        $sql = "SELECT DISTINCT c.*
                  FROM {assign_plugin_config} apc
                  JOIN {assign} a
                    ON apc.assignment = a.id
                  JOIN {course} c
                    ON a.course = c.id
                 WHERE apc.plugin = 'ctsubmission'
                   AND apc.subtype = 'assignsubmission'
                   AND apc.name = 'enabled'
                   AND apc.value = 1 
                   AND a.course {$insql}
              GROUP BY a.id
              ORDER BY c.shortname ASC";

        return $DB->get_records_sql($sql, $params);
    }

    /**
     * @param $courseid
     *
     * @return array
     */
    public static function get_ctsubmission_assignments($courseid){
        global $DB;
        $sql = "SELECT apc.id,
                       apc.assignment, 
                       a.course,
                       a.name
                  FROM {assign_plugin_config} apc 
                  JOIN {assign} a 
                    ON apc.assignment = a.id
                 WHERE apc.plugin = 'ctsubmission' 
                   AND apc.subtype = 'assignsubmission' 
                   AND apc.name = 'enabled'
                   AND apc.value = 1 
                   AND a.course = ?
              ORDER BY a.name ASC";

        return $DB->get_records_sql($sql, [$courseid]);
    }

    /**
     * @param $cmid
     * @param $userid
     *
     * @return bool
     */
    public static function is_mod_completed($cmid, $userid){
        global $DB;

        $cmcompletion = $DB->get_record('course_modules_completion', ['userid' => $userid, 'coursemoduleid' => $cmid]);
        if ($cmcompletion && $cmcompletion->completionstate){
            return true;
        }
        return false;
    }
}
