<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Proxy Overview.
 *
 * @package   assignsubmission_ctsubmission
 * @copyright 2021 Michael Gardener <mgardener@cissq.com>
 * @license   http://www.gnu.org/copyleft/gpl.html gnu gpl v3 or later
 */

use assignsubmission_ctsubmission\output\ct_overview;
use assignsubmission_ctsubmission\shared_lib as NED;

require_once(dirname(__FILE__, 5) . '/config.php');
/** @var object $CFG */
require_once($CFG->dirroot . '/mod/assign/locallib.php');
require_once($CFG->dirroot . '/blocks/ned_teacher_tools/common_data_utils.php');

$courseid = optional_param('courseid', 0, PARAM_INT);
$cmid = optional_param('cmid', 0, PARAM_INT);
$groupid = optional_param('groupid', 0, PARAM_INT);
$submissionstatus = optional_param('submissionstatus', 'showall', PARAM_TEXT);
$gt = optional_param('gt', '0', PARAM_INT);
$context = NED::ctx($courseid);

if ($courseid) {
    $course = $DB->get_record('course', ['id' => $courseid], '*', MUST_EXIST);
    require_login($course);
} else {
    require_login();
    $PAGE->set_context($context);
}

$url = new moodle_url('/mod/assign/submission/ctsubmission/overview.php', [
    'courseid' => $courseid,
    'cmid' => $cmid,
    'groupid' => $groupid,
    'submissionstatus' => $submissionstatus,
]);

NED::page_set_title('ctsubmissionsoverview', $url);
$overview = new ct_overview($courseid, $cmid, $groupid, $submissionstatus, $gt, $url->out_as_local_url());

echo $OUTPUT->header();
echo NED::render($overview);
echo $OUTPUT->footer();
