<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * CT Submission.
 *
 * @package   assignsubmission_ctsubmission
 * @copyright 2021 Michael Gardener <mgardener@cissq.com>
 * @license   http://www.gnu.org/copyleft/gpl.html gnu gpl v3 or later
 */

use assignsubmission_ctsubmission\submission;
use assignsubmission_ctsubmission\shared_lib as NED;

require_once(dirname(__FILE__, 5) . '/config.php');
/** @var object $CFG */
require_once($CFG->dirroot . '/mod/assign/locallib.php');

$id = required_param('id', PARAM_INT);
$groupid = optional_param('groupid', 0, PARAM_INT);
$returnurl = optional_param('returnurl', '', PARAM_LOCALURL);
$action = optional_param('action', false, PARAM_TEXT);

list($course, $cm) = get_course_and_cm_from_cmid($id, 'assign');
require_login($course, false, $cm);
$context = $cm->context;

$assign = new assign($context, $cm, $course);
$submission = $assign->get_group_submission($USER->id, $groupid, true, -1);
$ctsubmission = submission::get_record(['assignment' => $assign->get_instance()->id, 'submission' => $submission->id]);

if ($ctsubmission === false){
    $data = new stdClass();
    $data->assignment = $assign->get_instance()->id;
    $data->submission = $submission->id;
    $data->approved = 0;
    $ctsubmission = new submission(0, $data);
    $ctsubmission->create();
}

if ($returnurl){
    $redirecturl = new moodle_url($returnurl);
} else {
    $redirecturl = new moodle_url('/mod/assign/submission/ctsubmission/overview.php', ['courseid' => $course->id]);
}

if ($action !== false){
    require_capability('assignsubmission/ctsubmission:approve', $context);
    if (!$ctsubmission){
        redirect($redirecturl);
    }
    if ($action === 'approve'){
        $ctsubmission->set('approved', 1);

        $params = array(
            'context' => $context,
            'courseid' => $course->id,
            'objectid' => $submission->id,
            'other' => [
                'submissionid' => $submission->id,
                'submissionattempt' => $submission->attemptnumber,
                'submissionstatus' => $submission->status,
                'filesubmissioncount' => 0,
                'groupid' => $groupid,
                'groupname' => ''
            ]
        );
        $event = \assignsubmission_ctsubmission\event\submission_aproved::create($params);
        $event->trigger();
    } elseif ($action === 'unapprove'){
        $ctsubmission->set('approved', 0);
    } elseif ($action === 'revision'){
        $ctsubmission->set('approved', 2);
    }
    $ctsubmission->update();
    redirect($redirecturl);
}

require_capability('assignsubmission/ctsubmission:submit', $context);

/** @var assign_submission_proxy $assignsubmissionct */
$assignsubmissionct  = $assign->get_submission_plugin_by_type('ctsubmission');
$cfg = $assignsubmissionct->get_config();

if (empty($cfg->enabled)){
    NED::print_module_error('invalidmodule');
}

$url = NED::url('~/submit.php', ['id' => $id, 'groupid' => $groupid]);
$PAGE->navbar->add(NED::str('overview'), NED::url('~/overview.php', ['courseid' => $course->id]));
NED::page_set_title('submission', $url);

$mform = new \assignsubmission_ctsubmission\form\submission(null, [
    'assign' => $assign,
    'submission' => $submission,
    'assignsubmissionct' => $assignsubmissionct
]);

$fileoptions = $mform->get_file_options($assignsubmissionct);

$data = new stdClass();
$data->id = $id;
$data->userid = $USER->id;
$data->groupid = $groupid;
$data = file_prepare_standard_filemanager(
    $data,
    'files',
    $fileoptions,
    $assign->get_context(),
    'assignsubmission_ctsubmission',
    ASSIGNSUBMISSION_CTSUBMISSION_FILEAREA,
    $submission->id
);
$mform->set_data($data);

if ($mform->is_cancelled()){
    redirect($redirecturl);
} elseif ($fromform = $mform->get_data()){
    if (!is_siteadmin()){
        if (!$assign->submissions_open($USER->id)){
            redirect($redirecturl, get_string('duedatereached', 'assign'));
            die;
        }
    }

    $instance = $assign->get_instance();

    $plugin  = $assign->get_submission_plugin_by_type('ctsubmission');
    if ($plugin->is_enabled() && $plugin->is_visible()){
        if (!$plugin->save($submission, $fromform)){
            $msg = $plugin->get_error();
            redirect($redirecturl, $msg);
            die;
        }
    }

    if ($ctsubmission !== false){
        $ctsubmission->update();
    } else {
        $data = new stdClass();
        $data->assignment = $assign->get_instance()->id;
        $data->submission = $submission->id;
        $data->approved = 0;
        $ctsubmission = new submission(0, $data);
        $ctsubmission->create();
    }

    redirect($redirecturl);
    exit;
}

$assign->update_effective_access($USER->id);
echo $OUTPUT->header();
$mform->display();
echo $OUTPUT->footer();
