<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'flashcard', language 'en'
 *
 * @package     mod_flashcard
 * @category    mod
 * @copyright   Valery Fremaux, Tomasz Muras
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// Capabilities.
$string['flashcard:manage'] = 'Manage the cards';
$string['flashcard:canplayfree'] = 'Play free';
$string['flashcard:addinstance'] = 'Add a flashcard';

$string['addone'] = 'Add a new question';
$string['addthree'] = 'Add three new questions';
$string['answer'] = 'Answers';
$string['answersmediatype'] = 'Media type for answers';
$string['audiostart'] = 'Start sounds automatically';
$string['autodowngrade'] = 'Enable autodowngrade';
$string['avgaccess'] = 'Mean ticks per card ';
$string['backside'] = 'Flash Card Back';
$string['backtocourse'] = 'Back to course';
$string['backtodecks'] = 'Back to the deck table';
$string['badcards'] = 'Rejected card(s): ';
$string['bycards'] = 'By cards';
$string['byusers'] = 'By users';
$string['card'] = 'Card';
$string['cardback'] = 'Back card image';
$string['cardfront'] = 'Front card image';
$string['cardsep'] = 'Card Separator in text import:';
$string['cardsindeck'] = 'Remains : {$a} card(s)';
$string['cardsread'] = 'Card(s) read: ';
$string['cardsremaining'] = 'Cards Remaining';
$string['commands'] = '';
$string['completionallgoodenabled'] = 'Student must bring all cards in last deck to complete';
$string['completionallgoodgroup'] = 'Require all cards are known';
$string['completionallgoodhelp'] = 'requiring all cards are in last deck to complete';
$string['completionallviewed'] = 'Student must have viewed all cards once or at least some amount of them (cards):';
$string['completionallviewedgroup'] = 'Require viewing all cards';
$string['completiondiscussionshelp'] = 'requiring that all cards are viewed at least once';
$string['confirm'] = 'Confirm:';
$string['counters'] = 'Counters';
$string['crontask'] = 'Cron task for flashcard';
$string['customisationfiles'] = 'Card customisation files';
$string['deck'] = 'Deck';
$string['deck1_delay'] = 'Review triggering delay (deck 1)';
$string['deck2_delay'] = 'Review triggering delay (deck 2)';
$string['deck2_release'] = 'Autodowngrade overtime (deck 2)';
$string['deck3_delay'] = 'Review triggering delay (deck 3)';
$string['deck3_release'] = 'Autodowngrade overtime (deck 3)';
$string['deck4_delay'] = 'Review triggering delay (deck 4)';
$string['deck4_release'] = 'Autodowngrade overtime (deck 4)';
$string['deck_delay'] = 'Review triggering';
$string['deck_release'] = 'Autodowngrade';
$string['decks'] = 'Decks';
$string['deckstates'] = 'Decks state';
$string['deleteselected'] = 'Delete selected cards';
$string['deleteselection'] = 'Delete the selection';
$string['difficultcards'] = 'Hard set';
$string['easycards'] = 'Easy set';
$string['edit'] = 'Edit the cards';
$string['editingcards1'] = 'Edit Flashcard Set';
$string['editingcards2'] = 'Edit Flashcard Set';
$string['emptydeck'] = 'Empty deck image';
$string['emptyset'] = 'Flashcard Set is Empty';
$string['endtime'] = 'End of time';
$string['erroraddcard'] = 'Could not add card to deck';
$string['errorbindcard'] = 'Could not bind card to user {$a} deck';
$string['errordeletecard'] = 'Could not delete cards from deck';
$string['errorupdatecard'] = 'Could not update deck card';
$string['extracss'] = 'Extra css';
$string['fieldsep'] = 'Field separator:';
$string['flashcardneedsreview'] = 'Flashcard needs review';
$string['flipdeck'] = 'Flip answers and questions';
$string['forcereload'] = 'Force reloading from question';
$string['freegame'] = 'Free play';
$string['freeplayinstructions'] = 'Consider each card in the deck. If you think you know what the presented term means, click it to flip the card over and check your answer. If you got it right, click "Remove" to remove it from the deck. If you don&apos;t know the answer or are incorrect, go to the next card. When you have gone through all of the cards, review the course materials for information on the terms you don&apos;t know and try those cards again.';
$string['frontside'] = 'Flash Card Front';
$string['goodcards'] = 'Valid card(s) : ';
$string['havetologin'] = 'You have to log in before you can submit your choice';
$string['ifailed'] = 'I missed !';
$string['igotit'] = 'I got it !';
$string['image'] = 'image';
$string['imageplussound'] = 'image + sound';
$string['import'] = 'Import';
$string['importadvice'] = 'When importing new card set, you will remove all old cardset along with the previous information about user\'s plays';
$string['imported'] = 'Import:';
$string['importingcards'] = 'Import cards';
$string['importreport'] = '<b>Flashcard imported new cards:</b>';
$string['instructions'] = 'Click on the flashcard to turn it over and see the other side';
$string['lastaccessed'] = 'Last accessed';
$string['leitnergame'] = 'Leitner play';
$string['matchingquestion'] = 'Matching question from question bank';
$string['maxaccess'] = 'More viewed ticks ';
$string['mediatypes'] = 'Media type';
$string['mediumeffortcards'] = 'Middle effort set';
$string['minaccess'] = 'Less viewed ticks ';
$string['missingimage'] = '{missing image file}';
$string['missingsound'] = '{missing sound file}';
$string['missingvid'] = '{missing video file}';
$string['models'] = 'Gameplay';
$string['models_help'] = 'Enable or disable gameplay models';
$string['bothmodels'] = 'Both Leitner and free training';
$string['leitner'] = 'Leitner training';
$string['freeuse'] = 'Free training';
$string['modulename'] = 'Flash Card Set';
$string['modulenameplural'] = 'Flash Cards';
$string['next'] = 'Next card';
$string['nocards'] = 'No cards defined.';
$string['noflashcards'] = 'No flashcards in this course.';
$string['nomorecards'] = 'No more cards. ';
$string['nosubquestions'] = 'Error: Missing subquestions for this question!';
$string['notinitialized'] = 'This student never used this flashcard.';
$string['notifications'] = 'Notifications';
$string['nousers'] = 'No student in this course.';
$string['num'] = 'N°';
$string['numericrequired'] = 'A number is required.';
$string['outoftimerange'] = 'This module is closed by time range. You cannot use it now.';
$string['playwithme'] = 'Learn with that deck';
$string['pluginadministration'] = 'Flashcard administration.';
$string['pluginname'] = 'Flashcard';
$string['previous'] = 'Previous card';
$string['question'] = 'Questions';
$string['questionid'] = 'Question to import';
$string['questionsmediatype'] = 'Question media type';
$string['reinforce'] = 'Review this deck';
$string['removecard'] = 'Remove card';
$string['remindusers'] = 'Remind users';
$string['reset'] = 'Reset cardset';
$string['resetflashcardstates'] = 'Reset all flashcard states';
$string['reviewback'] = 'Needs review deck image';
$string['reviewedback'] = 'Reviewed deck image';
$string['reviewedempty'] = 'Empty reviewed deck image';
$string['sound'] = 'sound';
$string['sourcequestion'] = 'Question to import';
$string['starttime'] = 'Start time ';
$string['stylesheet'] = 'Obtain the stylesheet';
$string['styling'] = 'Customisation';
$string['sumaccess'] = 'Total viewed cards ';
$string['summary'] = 'Flash Card Set Summary';
$string['teachersummary'] = 'Summary';
$string['text'] = 'text';
$string['timetoreview'] = '{$a} days remaining before review';
$string['trivialcards'] = 'Trivial cards';
$string['undefinedquestionset'] = 'No matching question was elected in quizzes for this flashcard set';
$string['userdecks'] = 'Users\' decks';
$string['userdecksummary'] = 'Deck {$a->deckid}: {$a->count} cards ({$a->cardcount} hits in total on the deck)';
$string['video'] = 'Video';
$string['viewed'] = 'Viewes';

$string['privacy:metadata:flashcard_card:userid'] = 'The ID of the user having cards usage';
$string['privacy:metadata:flashcard_card:flashcardid'] = 'The ID of the flashcard';
$string['privacy:metadata:flashcard_card:entryid'] = 'The ID of the card in the card set';
$string['privacy:metadata:flashcard_card:deck'] = 'The current deck UD the card entry is in for this user';
$string['privacy:metadata:flashcard_card:lastaccessed'] = 'the time the card entry was last accessed by this user';
$string['privacy:metadata:flashcard_card'] = 'Stores the deck content for the user';

$string['privacy:metadata:flashcard_userdeck_state:userid'] = 'The ID of the user having cards usage';
$string['privacy:metadata:flashcard_userdeck_state:flashcardid'] = 'The ID of the flashcard';
$string['privacy:metadata:flashcard_userdeck_state:deck'] = 'The deck the state is for';
$string['privacy:metadata:flashcard_userdeck_state:state'] = 'The state of the deck (review status)';
$string['privacy:metadata:flashcard_userdeck_state'] = 'Stores deck states regarding to review requirement by the user';


/* Strings for the help section */

$string['modulename_help'] = '<p>
This module provide students a way of fast memoizing list of "things". This is a typical
indexing exercise, where a map of coupled things should be learned and retained. We say "thing"
because either key or value could be any related pair of text, images or sounds.
</p>
<p>
This module implements a full Leitner system to mechanically support the memoization process
of the relationships. The couples to be learned are first attached to a deck of cards. These are
initially considered as difficult to learn. The teacher can choose a learning curve using 2, 3 or 4 decks.
4 decks should be used for large set of definitions. When the student fails answering a card, he will
tell it and let the card stay in the same deck. If he has the correct answer, he will ask for passing the
card to the second deck, so considered as less difficult to learn. The process is repeated for all decks
till the last one where card will remain. The decks are triggered so the student knows which he should
review. Difficult cards will trigger more often thant trivial cards. Trigger delays are adjustable.
</p>
<p>
When a student do not apply for reviewing decks, cards may downgrade automatically to an higher difficulty
deck.
</p>
<p>
The module allows also a free use of the cards, enabled by module configuration. The module is
customisable graphically using a teacher defined CSS and image set.
</p>';

$string['sourcequestion_help'] = 'Choose a question as a source.

You may quickly setup a flashcard deck from a matching question of the question base. To proceed, choose a question in the list and check the "force reload" checkbox. All previous cards will be deleted and the flashcard will be reloaded with the question data.

Warning : changing cards using card editor WILL NOT change back question content in the question base.';
$string['forcereload_help'] = 'Force Reloading Cardset

Checking this checkbox will force the cardset to be reloaded with data from the choosen matching question.

All previously recorded user data will be deleted and all accounts will be reset.';
$string['mediatypes_help'] = 'This list defines the type of media used for questions.

* Text: The text entered is literally printed on the cards
* Image: The text entered is the location of an image file on the server, taken from the course files.
* Sound: The text entered is the location of a sound file on the server, taken from the course files.';
$string['flipdeck_help'] = 'This option allows invert the cards. If enabled, questions will be written on the cards backside as if they were answers and vice-versa.';
$string['decks_help'] = 'Allows choosing 2, 3, or 4 decks.

Typically, the Leitner system uses 3 decks. 4 decks will enlarge the memorization cycle so more difficult or larger cardsets can be learned. 2 decks will be convenient for easy sets or small size ensembles.';
$string['autodowngrade_help'] = 'This option enables automatic downgrade of cards. A game is eroded if the learner does not review the game for some time (see times below). Cards that are too old back in the packets more difficult to return the first packet. The erosion rate depends on the setting of various delays for each packet.';
$string['deck_release_help'] = 'Time in hours after which the cards go back into the upper deck. Each packet can be set differently.';
$string['deck_delay_help'] = 'Adjustable time in hours at which the packet is marked to be revised.';
$string['import_help'] = 'You may massively import question/Answer pairs within a flashcard using the
card bulk import feature. (Import can only be used for Text/Text flashcards.)

You just need to make a file with a list of questions/answers pairs and paste the content of that file in the importer\'s textarea.
You may decide to encode this file with some kinds of common separators, on Linux or
Windows systems. The most common may be "one pair by line" files, using \':\' or comma to
separate questions from answers.

Questions will only comme first, and MUST always have an answer. Empty lines or black lines will be ignored, also those starting with a # or a slash (/).

The importer will make a fast check of the text you want to import. It will reject
the import if the text sequence is not well formed and tell you how many pairs are wrong in the file.

As successfuly importing will erase all data from the decks but also belonging to participants, a confirmation checkbox needs to be checked in to force the import to be performed.';

$string['notify_review_tpl'] = '
Hi <%%FULLNAME%%>

A flashcard activity is requiring your attention. You have some cards to review
in course <%%COURSE%%> :

<%%URL%%>
';

$string['notify_review_html_tpl'] = '
<p>Hi <%%FULLNAME%%></p>

<p>A flashcard activity is requiring your attention. You have some cards to review
in course <b><%%COURSE%%></b> : </p>

<a href="<%%URL%%>"><%%URL%%></a>
';