<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Backup steps for mod_nedactivitycluster are defined here.
 *
 * @package     mod_nedactivitycluster
 * @category    backup
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

/**
 * Define the complete structure for backup, with file and id annotations.
 */
class backup_nedactivitycluster_activity_structure_step extends backup_activity_structure_step {

    /**
     * Defines the structure of the resulting xml file.
     *
     * @return backup_nested_element The structure wrapped by the common 'activity' element.
     */
    protected function define_structure() {
        $userinfo = $this->get_setting_value('userinfo');

        $nedactivitycluster = new backup_nested_element(
            'nedactivitycluster',
            array('id'),
            array(
                'name', 'intro', 'introformat', 'showactivitytypecolumn',
                'showpassfailbackgroundcolors', 'showgrade','showstudentmenu',
                'showtitleheader','allactivitiesmustbecompleted', 'pulldatafromquestionnaire' , 'questionnairequestionname',
                'questionnametoshow', 'calculatetotal', 'calculatetargettotal'
            )
        );

        $clusters = new backup_nested_element('clusters');

        $cluster = new backup_nested_element(
            'cluster',
            array('id'),
            array('section', 'name', 'summary', 'summaryformat', 'sequence', 'timemodified')
        );

        // Build the tree
        $nedactivitycluster->add_child($clusters);
        $clusters->add_child($cluster);

        // Define sources
        $nedactivitycluster->set_source_table('nedactivitycluster', array('id' => backup::VAR_ACTIVITYID));
        $cluster->set_source_table('nedactivitycluster_clusters', array('nedactivitycluster' => backup::VAR_PARENTID));


        // Define file annotations
        $nedactivitycluster->annotate_files('mod_nedactivitycluster', 'intro', null); // This file areas haven't itemid
        $cluster->annotate_files('mod_nedactivitycluster', 'summary', null);


        return $this->prepare_activity_structure($nedactivitycluster);
    }
}
