<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * The task that provides a complete restore of mod_nedactivitycluster is defined here.
 *
 * @package     mod_nedactivitycluster
 * @category    restore
 * @copyright   2018 Michael Gardener <mgardener@cissq.com>
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

require_once($CFG->dirroot.'/mod/nedactivitycluster/backup/moodle2/restore_nedactivitycluster_stepslib.php');

/**
 * Restore task for mod_nedactivitycluster.
 */
class restore_nedactivitycluster_activity_task extends restore_activity_task {

    /**
     * Defines particular settings that this activity can have.
     */
    protected function define_my_settings() {
        return;
    }

    /**
     * Defines particular steps that this activity can have.
     *
     * @return base_step.
     */
    protected function define_my_steps() {
        $this->add_step(new restore_nedactivitycluster_activity_structure_step('nedactivitycluster_structure', 'nedactivitycluster.xml'));
    }

    /**
     * Defines the contents in the activity that must be processed by the link decoder.
     *
     * @return array.
     */
    static public function define_decode_contents() {
        $contents = array();

        $contents[] = new restore_decode_content('nedactivitycluster', array('intro'), 'nedactivitycluster');
        $contents[] = new restore_decode_content('nedactivitycluster_clusters', array('summary'), 'nedactivitycluster_clusters');

        return $contents;
    }

    /**
     * Defines the decoding rules for links belonging to the activity to be executed by the link decoder.
     *
     * @return array.
     */
    static public function define_decode_rules() {
        $rules = array();

        $rules[] = new restore_decode_rule('NEDACTIVITYCLUSTERVIEWBYID', '/mod/nedactivitycluster/view.php?id=$1', 'course_module');
        $rules[] = new restore_decode_rule('NEDACTIVITYCLUSTERINDEX', '/mod/nedactivitycluster/index.php?id=$1', 'course');

        return $rules;
    }

    /**
     * Defines the restore log rules that will be applied by the
     * {@link restore_logs_processor} when restoring mod_activitycluster logs. It
     * must return one array of {@link restore_log_rule} objects.
     *
     * @return array.
     */
    static public function define_restore_log_rules() {
        $rules = array();

        $rules[] = new restore_log_rule('nedactivitycluster', 'add', 'view.php?id={course_module}', '{nedactivitycluster}');
        $rules[] = new restore_log_rule('nedactivitycluster', 'update', 'view.php?id={course_module}', '{nedactivitycluster}');
        $rules[] = new restore_log_rule('nedactivitycluster', 'view', 'view.php?id={course_module}', '{nedactivitycluster}');

        return $rules;
    }

    /**
     * @return array
     */
    public static function define_restore_log_rules_for_course() {

        $rules = array();
        $rules[] = new restore_log_rule('nedactivitycluster', 'view all', 'index.php?id={course}', null);

        return $rules;
    }

    /**
     * @throws dml_exception
     */
    public function after_restore() {
        global $DB;

        $rcm = $DB->get_recordset('nedactivitycluster_clusters', array('nedactivitycluster' => $this->get_activityid()));
        foreach ($rcm as $rc) {
            if ($rc->sequence) {
                $cmids = explode(',',  $rc->sequence);
                foreach ($cmids as $index => $cmid) {
                    if (!$DB->record_exists('course_modules', array('id' => $cmid, 'course' => $this->get_courseid()))) {
                        if ($newitem = restore_dbops::get_backup_ids_record($this->get_restoreid(), 'course_module', $cmid)) {
                            $cmids[$index] = $newitem->newitemid;
                        } else {
                            unset($cmids[$index]);
                        }
                    }
                }

                $rc->sequence = implode(',', $cmids);
                $DB->update_record('nedactivitycluster_clusters', $rc);
            }
        }
        $rcm->close();
    }
}
